; -------------------------------------------------------------------------------------------------------------- ;
; Beach Head - LOCODE.prg
; -------------------------------------------------------------------------------------------------------------- ;
; Memory Map
; -------------------------------------------------------------------------------------------------------------- ;
; $0000 - $00ff:  Zero Page Values
; $0200 - $02ff:  Work Values and C64 system
; $0300 - $03ff:  Work Values and C64 system
; -------------------------------------------------------------------------------------------------------------- ;
                        * equ $1e00
; -------------------------------------------------------------------------------------------------------------- ;
; compiler settings
; -------------------------------------------------------------------------------------------------------------- ;
                        incdir  ..\inc              ; C64 System Includes

C64CIA1                 include cia1.asm            ; Complex Interface Adapter (CIA) #1 Registers  $DC00-$DC0F
C64CIA2                 include cia2.asm            ; Complex Interface Adapter (CIA) #2 Registers  $DD00-$DD0F
C64SID                  include sid.asm             ; Sound Interface Device (SID) Registers        $D400-$D41C
C64VicII                include vic.asm             ; Video Interface Chip (VIC-II) Registers       $D000-$D02E
C64Kernel               include kernel.asm          ; Kernel Vectors
C64Colors               include color.asm           ; Colour RAM Address / Colours
C64Memory               include mem.asm             ; Memory Layout

Game                    include inc\BH_Game.asm     ; Game Variables
Externals               include inc\BH_Externals.asm; Subroutines and Tables
ZeroPage                include inc\BH_Zpg.asm      ; Zero Page Addresses

Equates                 include inc\BL_Equates.asm  ; External and Unresolved Addresses
; -------------------------------------------------------------------------------------------------------------- ;
; S_1e00                Does    : 
;                       Expects : 
;                       Returns : 
; -------------------------------------------------------------------------------------------------------------- ;
S_1e00                  subroutine                  ; 
                        jsr LO_2540                 ; 
                        jsr LO_254b                 ; 
                        lda #$14                    ; 
                        sta FREHI1                  ; SID($D401) Oscillator 1 Freq Ctrl (high byte)
                        lda #$30                    ; 
                        sta SUREL1                  ; SID($D406) Oscillator 1 Sustain/Release
                        lda #$00                    ; 
                        sta FRELO2                  ; SID($D407) Oscillator 2 Freq Ctrl (low byte)
                        lda #$02                    ; 
                        sta FREHI2                  ; SID($D408) Oscillator 2 Freq Ctrl (high byte)
                        lda #$50                    ; 
                        sta SUREL2                  ; SID($D40D) Oscillator 2 Sustain/Release
                        lda #$21                    ; 
                        jsr S_21c7                  ; 
                        lda #$01                    ; 
                        sta HI_96ad                 ; 
                        sta HI_96fd                 ; 
                        rts                         ; 
; -------------------------------------------------------------------------------------------------------------- ;
; S_1e2d                Does    : 
;                       Expects : 
;                       Returns : 
; -------------------------------------------------------------------------------------------------------------- ;
S_1e2d                  subroutine                  ; 
                        lda HI_96d5                 ; 
                        beq B_1e33                  ; 
                        
                        rts                         ; 
                        
B_1e33                  inc HI_96d5                 ; 
                        
                        lda SP0Y                    ; VIC($D001) Sprite 0 Y-Pos (Bits 0-7)
                        sec                         ; 
                        sbc #$68                    ; 
                        asl a                       ; 
                        sta FRELO2                  ; SID($D407) Oscillator 2 Freq Ctrl (low byte)
                        sta FRELO1                  ; SID($D400) Oscillator 1 Freq Ctrl (low byte)
                        nop                         ; 
                        nop                         ; 
                        nop                         ; 
                        nop                         ; 
                        nop                         ; 
                        nop                         ; 
                        nop                         ; 
                        rts                         ; 
; -------------------------------------------------------------------------------------------------------------- ;
; LO_1e4b               Does    : 
;                       Expects : 
;                       Returns : 
; -------------------------------------------------------------------------------------------------------------- ;
LO_1e4b                 subroutine                  ; 
                        lda HI_96d6                 ; 
                        beq B_1e51                  ; 
                        rts                         ; 
; -------------------------------------------------------------------------------------------------------------- ;
B_1e51                  jsr LO_2556                 ; 
                        lda #$0a                    ; 
                        sta ATDCY3                  ; SID($D413) Oscillator 3 Attack/Decay
                        lda #$14                    ; 
                        sta FREHI3                  ; SID($D40F) Oscillator 3 Freq Ctrl (high byte)
                        lda #$81                    ; 
                        sta VCREG3                  ; SID($D412) Oscillator 3 Control
                        lda #$0a                    ; 
                        sta HI_96ae                 ; 
                        inc HI_96d6                 ; 
                        rts                         ; 
; -------------------------------------------------------------------------------------------------------------- ;
LO_1e6c                 nop                         ; 
                        nop                         ; 
                        nop                         ; 
                        nop                         ; 
                        nop                         ; 
                        nop                         ; 
                        jsr LO_2556                 ; 
                        lda #$0c                    ; 
                        sta ATDCY3                  ; SID($D413) Oscillator 3 Attack/Decay
                        lda #$0a                    ; 
                        sta FREHI3                  ; SID($D40F) Oscillator 3 Freq Ctrl (high byte)
                        lda #$81                    ; 
                        sta VCREG3                  ; SID($D412) Oscillator 3 Control
                        lda #$3c                    ; 
                        sta HI_96ae                 ; 
                        inc HI_96d6                 ; 
                        rts                         ; 
; -------------------------------------------------------------------------------------------------------------- ;
LO_1e8d                 jsr ResetTOD                ; 
B_1e90                  jsr S_1e2d                  ; 
                        
                        lda #$01                    ; 
                        sta FREHI2                  ; SID($D408) Oscillator 2 Freq Ctrl (high byte)
                        
                        lda TODSEC                  ; CIA1($DC09) Time of Day Clock Seconds
                        ldx TODTEN                  ; CIA1($DC08) Time of Day Clock Tenths
                        cmp HI_9617                 ; 
                        bne B_1e90                  ; 
                        
                        lda #$02                    ; 
                        sta FREHI2                  ; SID($D408) Oscillator 2 Freq Ctrl (high byte)
                        
                        rts                         ; 
; -------------------------------------------------------------------------------------------------------------- ;
; S_1ea9                Does    : 
;                       Expects : 
;                       Returns : 
; -------------------------------------------------------------------------------------------------------------- ;
S_1ea9                  subroutine                  ; 
                        lda #$80                    ; 
                        sta FRELO1                  ; SID($D400) Oscillator 1 Freq Ctrl (low byte)
                        lda #$00                    ; 
                        sta FREHI1                  ; SID($D401) Oscillator 1 Freq Ctrl (high byte)
                        rts                         ; 
; -------------------------------------------------------------------------------------------------------------- ;
LO_1eb4                 jsr LO_2556                 ; 
                        lda #$34                    ; 
                        sta FREHI3                  ; SID($D40F) Oscillator 3 Freq Ctrl (high byte)
                        lda #$0a                    ; 
                        sta ATDCY3                  ; SID($D413) Oscillator 3 Attack/Decay
                        lda #$81                    ; 
                        sta VCREG3                  ; SID($D412) Oscillator 3 Control
                        rts                         ; 
; -------------------------------------------------------------------------------------------------------------- ;
; S_1ec7                Does    : 
;                       Expects : 
;                       Returns : 
; -------------------------------------------------------------------------------------------------------------- ;
S_1ec7                  subroutine                  ; 
                        jsr LO_2540                 ; 
                        nop                         ; 
                        nop                         ; 
                        nop                         ; 
                        nop                         ; 
                        nop                         ; 
                        nop                         ; 
                        nop                         ; 
                        nop                         ; 
                        nop                         ; 
                        nop                         ; 
                        lda #$02                    ; 
                        sta PWHI1                   ; SID($D403) Oscillator 1 Pulse Waveform Width (high nybble)
                        lda #$40                    ; 
                        sta SUREL1                  ; SID($D406) Oscillator 1 Sustain/Release
                        lda #$41                    ; 
                        sta VCREG1                  ; SID($D404) Oscillator 1 Control
                        rts                         ; 
; -------------------------------------------------------------------------------------------------------------- ;
LO_1ee4                 jsr LO_2540                 ; 
                        jsr LO_2556                 ; 
                        lda HI_97ce                 ; 
                        sta CUTHI                   ; SID($D416) Filter Cutoff Frequency (high byte)
                        lda #$06                    ; 
                        sta FREHI1                  ; SID($D401) Oscillator 1 Freq Ctrl (high byte)
                        sta FREHI3                  ; SID($D40F) Oscillator 3 Freq Ctrl (high byte)
                        lda #$0d                    ; 
                        sta ATDCY1                  ; SID($D405) Oscillator 1 Attack/Decay2
                        sta ATDCY3                  ; SID($D413) Oscillator 3 Attack/Decay
                        lda #$81                    ; 
                        sta VCREG1                  ; SID($D404) Oscillator 1 Control
                        sta VCREG3                  ; SID($D412) Oscillator 3 Control
                        rts                         ; 
; -------------------------------------------------------------------------------------------------------------- ;
LO_1f09                 jsr LO_2540                 ; 
                        jsr LO_254b                 ; 
                        jsr LO_2556                 ; 
                        lda HI_97ce                 ; 
                        sta CUTHI                   ; SID($D416) Filter Cutoff Frequency (high byte)
                        lda #$08                    ; 
                        sta FREHI1                  ; SID($D401) Oscillator 1 Freq Ctrl (high byte)
                        lda #$07                    ; 
                        sta FREHI2                  ; SID($D408) Oscillator 2 Freq Ctrl (high byte)
                        lda #$09                    ; 
                        sta FREHI3                  ; SID($D40F) Oscillator 3 Freq Ctrl (high byte)
                        lda #$0e                    ; 
                        sta ATDCY1                  ; SID($D405) Oscillator 1 Attack/Decay2
                        sta ATDCY2                  ; SID($D40C) Oscillator 2 Attack/Decay
                        sta ATDCY3                  ; SID($D413) Oscillator 3 Attack/Decay
                        lda #$81                    ; 
                        sta VCREG1                  ; SID($D404) Oscillator 1 Control
                        sta VCREG2                  ; SID($D40B) Oscillator 2 Control
                        sta VCREG3                  ; SID($D412) Oscillator 3 Control
                        rts                         ; 
; -------------------------------------------------------------------------------------------------------------- ;
LO_1f3e                 lda #$00                    ; 
                        sta FRELO1                  ; SID($D400) Oscillator 1 Freq Ctrl (low byte)
                        sta FREHI1                  ; SID($D401) Oscillator 1 Freq Ctrl (high byte)
                        lda #$28                    ; 
                        sta HI_968b                 ; 
                        rts                         ; 
; -------------------------------------------------------------------------------------------------------------- ;
; S_1f4c                Does    : 
;                       Expects : 
;                       Returns : 
; -------------------------------------------------------------------------------------------------------------- ;
S_1f4c                  subroutine                  ; 
                        jmp HI_66ac                 ; 
; -------------------------------------------------------------------------------------------------------------- ;
; SimpleCheckBasicMods  Does    : 
;                       Expects : 
;                       Returns : 
; -------------------------------------------------------------------------------------------------------------- ;
SimpleCheckBasicMods    lda BH_TabVicMemControlSetA ; 
                        clc                         ; 
                        adc #$25                    ; 
                        cmp Basic_Line01_Val69      ; basic line 1: poke 670,69 ($45)
                        beq SimpleCheckBasicModsX   ; no changes
                        
.Destroy                sta BH_TabVicMemControlSetA ; 
                        sta BH_TabVicMemControlSetB ; 
                        
SimpleCheckBasicModsX   rts                         ; 
; -------------------------------------------------------------------------------------------------------------- ;
                        sta ATDCY1                  ; SID($D405) Oscillator 1 Attack/Decay2
                        lda #$81                    ; 
                        sta VCREG1                  ; SID($D404) Oscillator 1 Control
                        rts                         ; 
; -------------------------------------------------------------------------------------------------------------- ;
                        sta HI_9756,x               ; 
                        lda #$01                    ; 
                        sta BH_TabNumberOfPlayers   ; 
                        sta HI_9602                 ; 
                        rts                         ; 
; -------------------------------------------------------------------------------------------------------------- ;
LO_1f76                 sta HI_9628                 ; 
                        lda #$00                    ; 
                        sta HI_961e                 ; 
                        rts                         ; 
; -------------------------------------------------------------------------------------------------------------- ;
J_1f7f                  cpx #$c8                    ; Part2: Restore status screen
                        bne B_1f94                  ; 
                        
                        ldx BH_TabActualPlayerNumber; 
                        inx                         ; 
                        txa                         ; 
                        jsr MakeDigit               ; xr=right nibble yr=left nibble
                        
                        sty BH_Scrn_Status + $0353  ; 
                        
                        lda #YELLOW                 ; 
                        sta COLORAM + $0353         ; 
                        
                        rts                         ; 
                        
B_1f94                  jmp J_3881                  ; 
; -------------------------------------------------------------------------------------------------------------- ;
LO_1f97                 ldx #$01                    ; 
B_1f99                  lda BH_TabPlayerLivesSav,x  ; 
                        asl a                       ; 
                        sta HI_9747,x               ; 
                        dex                         ; 
                        bpl B_1f99                  ; 
                        rts                         ; 
; -------------------------------------------------------------------------------------------------------------- ;
LO_1fa4                 lda #$04                    ; 
                        sta BH_TabPlayerLives       ; 
                        jsr HI_8d82                 ; 
                        jsr LO_2bdf                 ; 
                        
                        jmp HI_6b0a                 ; 
; -------------------------------------------------------------------------------------------------------------- ;
J_1fb2                  jsr ScreenStatusTextOutRow3 ; xr=input text offset  yr=output text offset (Player two)
                        
                        lda #BH_TabGameModeDemo     ; 
                        ldx BH_TabGameMode          ; 
                        bne B_1fbf                  ; 
                        
                        jmp J_3862                  ; 
                        
B_1fbf                  jmp J_3864                  ; 
; -------------------------------------------------------------------------------------------------------------- ;
LO_1fc2                 txa                         ; 
                        pha                         ; 
                        lda HI_97bf                 ; 
                        cmp #$05                    ; 
                        bne B_1fce                  ; 
                        jsr HI_7cf1                 ; 
B_1fce                  pla                         ; 
                        tax                         ; 
                        stx HI_97bf                 ; 
                        rts                         ; 
; -------------------------------------------------------------------------------------------------------------- ;
LO_1fd4                 ldy #$40                    ; 
                        lda XT_03bf,y               ; 
                        cmp #$42                    ; 
                        beq B_1fe3                  ; 
                        
                        sta HI_95ec,y               ; 
                        
                        ldy #$01                    ; 
                        pla                         ; 
                        
B_1fe3                  rts                         ; 
; -------------------------------------------------------------------------------------------------------------- ;
                        jsr ScreenStatusTextOutRow3 ; xr=input text offset  yr=output text offset
                        
                        ldy #$16                    ; 
                        ldx #OffTextStatusEndOfTxt  ; 
                        jsr ScreenStatusTextOutRow4 ; xr=input text offset  yr=output text offset
                        
                        rts                         ; 
; -------------------------------------------------------------------------------------------------------------- ;
LO_1fef                 sta HI_972b                 ; 
                        sta BH_SpritePointer04      ; 
                        
                        rts                         ; 
; -------------------------------------------------------------------------------------------------------------- ;
A_1ff6                  dc.b $31 ; 1
                        dc.b $30 ; 0
                        dc.b $39 ; 9
                        dc.b $38 ; 8
                        dc.b $37 ; 7
                        dc.b $36 ; 6
                        dc.b $35 ; 5
                        dc.b $34 ; 4
                        dc.b $33 ; 3
                        dc.b $32 ; 2
; -------------------------------------------------------------------------------------------------------------- ;
                        jsr LO_34f9                 ; 
                        jsr S_23a2                  ; 
                        
                        rts                         ; 
; -------------------------------------------------------------------------------------------------------------- ;
; S_2007                Does    : 
;                       Expects : 
;                       Returns : 
; -------------------------------------------------------------------------------------------------------------- ;
S_2007                  subroutine                  ; 
                        jsr S_231d                  ; 
                        jsr S_23c0                  ; 
                        rts                         ; 
; -------------------------------------------------------------------------------------------------------------- ;
; S_200e                Does    : 
;                       Expects : 
;                       Returns : 
; -------------------------------------------------------------------------------------------------------------- ;
S_200e                  subroutine                  ; 
                        jsr LO_28db                 ; 
                        lda GR_bed0,x               ; 
                        cmp #$0d                    ; 
                        bne B_201b                  ; 
                        jsr S_23a2                  ; 
B_201b                  rts                         ; 
; -------------------------------------------------------------------------------------------------------------- ;
XS_201c                 jsr S_2387                  ; 
                        
                        lda #$f7                    ; 
                        and HI_97c9                 ; 
                        sta HI_97c9                 ; 
                        
                        rts                         ; 
; -------------------------------------------------------------------------------------------------------------- ;
XS_2028                 lda BH_TabVicMemControlSetA ; 
                        jsr SidInit                 ; 
                        
                        rts                         ; 
; -------------------------------------------------------------------------------------------------------------- ;
; SidSetVolFilter       Does    : 
;                       Expects : 
;                       Returns : 
; -------------------------------------------------------------------------------------------------------------- ;
SidSetVolFilter         subroutine                  ; 
                        lda #$1f                    ; 
                        sta SIGVOL                  ; SID($D418) Volume/Filter Select
                        
                        lda #$f7                    ; 
                        sta RESON                   ; SID($D417) Filter Resonance Ctrl
                        
                        lda T_2040,x                ; 
                        jsr SidSetCuthi             ; 
                        
SidSetVolFilterX        rts                         ; 
; -------------------------------------------------------------------------------------------------------------- ;
T_2040                  dc.b $00 ; 
                        dc.b $ff ; 
                        dc.b $80 ; 
                        dc.b $70 ; 
                        dc.b $60 ; 
                        dc.b $70 ; 
                        dc.b $70 ; 
T_2047                  dc.b $5a ; 
; -------------------------------------------------------------------------------------------------------------- ;
; GoSetVolInit_FB       Does    : 
;                       Expects : 
;                       Returns : 
; -------------------------------------------------------------------------------------------------------------- ;
GoSetVolInit_FB         subroutine                  ; 
                        jsr SidSetVolFilter         ; 
                        
                        lda #<BH_SpriteStore        ; 
                        sta BLZ_SpriteDataPtrOutLo  ; 
                        
GoSetVolInit_FBX        rts                         ; 
; -------------------------------------------------------------------------------------------------------------- ;
LO_2050                 jsr S_2387                  ; 
                        
                        lda #$f7                    ; ####.###
                        and HI_97c9                 ; 
                        ora #$01                    ; .......#
                        sta HI_97c9                 ; 
                        
                        jsr S_22d9                  ; 
                        rts                         ; 
; -------------------------------------------------------------------------------------------------------------- ;
; S_2061                Does    : 
;                       Expects : 
;                       Returns : 
; -------------------------------------------------------------------------------------------------------------- ;
S_2061                  subroutine                  ; 
                        lda #$0b                    ; 
                        sta HI_97cc                 ; 
                        lda #$1c                    ; 
                        sta HI_97cd                 ; 
                        rts                         ; 
; -------------------------------------------------------------------------------------------------------------- ;
LO_206c                 sta SP2COL                  ; VIC($D029) Color Sprite 2
                        jsr S_2061                  ; 
                        rts                         ; 
; -------------------------------------------------------------------------------------------------------------- ;
; S_2073                Does    : 
;                       Expects : 
;                       Returns : 
; -------------------------------------------------------------------------------------------------------------- ;
S_2073                  subroutine                  ; 
                        lda #$0c                    ; 
                        sta HI_97cc                 ; 
                        lda #$08                    ; 
                        jsr S_2195                  ; 
                        rts                         ; 
; -------------------------------------------------------------------------------------------------------------- ;
LO_207e                 sta HI_972a                 ; 
                        jsr S_2073                  ; 
                        rts                         ; 
; -------------------------------------------------------------------------------------------------------------- ;
; S_2085                Does    : 
;                       Expects : 
;                       Returns : 
; -------------------------------------------------------------------------------------------------------------- ;
S_2085                  subroutine                  ; 
                        lda #$10                    ; 
                        
                        bit HI_97c9                 ; 
                        bne B_20a3                  ; 
                        
                        jsr LO_2540                 ; 
                        nop                         ; 
                        nop                         ; 
                        nop                         ; 
                        nop                         ; 
                        nop                         ; 
                        lda #$9e                    ; 
                        sta FREHI1                  ; SID($D401) Oscillator 1 Freq Ctrl (high byte)
                        lda #$0c                    ; 
                        sta ATDCY1                  ; SID($D405) Oscillator 1 Attack/Decay2
                        lda #$81                    ; 
                        sta VCREG1                  ; SID($D404) Oscillator 1 Control
B_20a3                  nop                         ; 
                        nop                         ; 
                        nop                         ; 
                        nop                         ; 
                        nop                         ; 
                        nop                         ; 
                        nop                         ; 
                        nop                         ; 
                        rts                         ; 
; -------------------------------------------------------------------------------------------------------------- ;
; S_20ac                Does    : 
;                       Expects : 
;                       Returns : 
; -------------------------------------------------------------------------------------------------------------- ;
S_20ac                  subroutine                  ; 
                        lda HI_972c                 ; 
                        cmp #$01                    ; 
                        beq B_20b4                  ; 
                        
B_20b3                  rts                         ; 
                        
B_20b4                  lda #$20                    ; 
                        
                        bit HI_97c9                 ; 
                        bne B_20b3                  ; 
                        
                        lda HI_9720                 ; 
                        cmp #$02                    ; 
                        bne B_20b3                  ; 
                        
                        lda #$20                    ; ..#.....
                        ora HI_97c9                 ; 
                        sta HI_97c9                 ; 
                        
                        lda #$01                    ; 
                        sta HI_96ad                 ; 
                        lda #$02                    ; 
                        sta HI_96fd                 ; 
                        inc HI_96d5                 ; 
                        jsr LO_2556                 ; 
                        nop                         ; 
                        nop                         ; 
                        nop                         ; 
                        nop                         ; 
                        nop                         ; 
                        lda #$f0                    ; 
                        sta ATDCY3                  ; SID($D413) Oscillator 3 Attack/Decay
                        lda #$ff                    ; 
                        sta HI_97cb                 ; 
                        lda #$11                    ; 
                        sta VCREG3                  ; SID($D412) Oscillator 3 Control
                        rts                         ; 
; -------------------------------------------------------------------------------------------------------------- ;
; S_20ef                Does    : 
;                       Expects : 
;                       Returns : 
; -------------------------------------------------------------------------------------------------------------- ;
S_20ef                  subroutine                  ; 
                        lda #$20                    ; 
                        
                        bit HI_97c9                 ; 
                        bne B_20f7                  ; 
                        
B_20f6                  rts                         ; 
                        
B_20f7                  lda HI_96d5                 ; 
                        bne B_20f6                  ; 
                        
                        inc HI_96d5                 ; 
                        lda HI_97cb                 ; 
                        sec                         ; 
                        sbc #$01                    ; 
                        sta HI_97cb                 ; 
                        sta FREHI3                  ; SID($D40F) Oscillator 3 Freq Ctrl (high byte)
                        rts                         ; 
; -------------------------------------------------------------------------------------------------------------- ;
; S_210c                Does    : 
;                       Expects : 
;                       Returns : 
; -------------------------------------------------------------------------------------------------------------- ;
S_210c                  subroutine                  ; 
                        lda #$cf                    ; ##..####
                        and HI_97c9                 ; 
                        sta HI_97c9                 ; 
                        
                        jsr LO_2556                 ; 
                        lda #$24                    ; 
                        sta FREHI3                  ; SID($D40F) Oscillator 3 Freq Ctrl (high byte)
                        lda #$4c                    ; 
                        sta ATDCY3                  ; SID($D413) Oscillator 3 Attack/Decay
                        lda #$81                    ; 
                        sta VCREG3                  ; SID($D412) Oscillator 3 Control
                        rts                         ; 
; -------------------------------------------------------------------------------------------------------------- ;
; S_2127                Does    : 
;                       Expects : 
;                       Returns : 
; -------------------------------------------------------------------------------------------------------------- ;
S_2127                  subroutine                  ; 
                        jsr LO_2540                 ; 
                        
                        lda #$df                    ; ##.#####
                        and HI_97c9                 ; 
                        ora #$10                    ; ...#....
                        sta HI_97c9                 ; 
                        
                        lda #$06                    ; 
                        sta FREHI1                  ; SID($D401) Oscillator 1 Freq Ctrl (high byte)
                        lda #$0d                    ; 
                        sta ATDCY1                  ; SID($D405) Oscillator 1 Attack/Decay2
                        jsr LO_2556                 ; 
                        nop                         ; 
                        nop                         ; 
                        lda #$81                    ; 
                        sta VCREG1                  ; SID($D404) Oscillator 1 Control
                        rts                         ; 
; -------------------------------------------------------------------------------------------------------------- ;
LO_2149                 jmp J_2187                  ; 
; -------------------------------------------------------------------------------------------------------------- ;
J_214c                  lda #$50                    ; 
                        sta FREHI1                  ; SID($D401) Oscillator 1 Freq Ctrl (high byte)
                        lda #$0d                    ; 
                        sta ATDCY1                  ; SID($D405) Oscillator 1 Attack/Decay2
                        lda #$81                    ; 
                        sta VCREG1                  ; SID($D404) Oscillator 1 Control
                        rts                         ; 
; -------------------------------------------------------------------------------------------------------------- ;
LO_215c                 sta SP2Y                    ; VIC($D005) Sprite 2 Y-Pos (Bits 0-7)
                        jsr S_2085                  ; 
                        rts                         ; 
; -------------------------------------------------------------------------------------------------------------- ;
LO_2163                 jsr S_3a74                  ; 
                        jsr S_20ac                  ; 
                        jsr S_20ef                  ; 
                        rts                         ; 
; -------------------------------------------------------------------------------------------------------------- ;
LO_216d                 sta SP2Y                    ; VIC($D005) Sprite 2 Y-Pos (Bits 0-7)
                        jsr S_210c                  ; 
                        rts                         ; 
; -------------------------------------------------------------------------------------------------------------- ;
LO_2174                 jsr S_2127                  ; 
                        dec BH_TabPlayerLives       ; 
                        rts                         ; 
; -------------------------------------------------------------------------------------------------------------- ;
; S_217b                Does    : 
;                       Expects : 
;                       Returns : 
; -------------------------------------------------------------------------------------------------------------- ;
S_217b                  subroutine                  ; 
                        jsr SidInit                 ; 
                        
                        lda #$00                    ; 
                        sta HI_97c9                 ; 
                        
                        lda BH_TabVicMemControlSetA ; 
                        
                        rts                         ; 
; -------------------------------------------------------------------------------------------------------------- ;
J_2187                  lda #$10                    ; 
                        
                        bit HI_97c9                 ; 
                        beq B_218f                  ; 
                        
                        rts                         ; 
                        
B_218f                  jsr LO_2540                 ; 
                        jmp J_214c                  ; 
; -------------------------------------------------------------------------------------------------------------- ;
; S_2195                Does    : 
;                       Expects : 
;                       Returns : 
; -------------------------------------------------------------------------------------------------------------- ;
S_2195                  subroutine                  ; 
                        sta HI_97cd                 ; 
                        lda #$f3                    ; 
                        sta RESON                   ; SID($D417) Filter Resonance Ctrl
                        rts                         ; 
; -------------------------------------------------------------------------------------------------------------- ;
LO_219e                 lda #WHITE                  ; 
                        sta BH_TabScrnStatusTextColor ; 
                        
                        ldy #$16                    ; 
                        ldx #OffTextStatusDamage    ; 
                        jsr ScreenStatusTextOutRow5 ; xr=input text offset  yr=output text offset
                        
                        rts                         ; 
; -------------------------------------------------------------------------------------------------------------- ;
LO_21ab                 lda HI_960d                 ; 
                        ora HI_972b                 ; 
                        rts                         ; 
; -------------------------------------------------------------------------------------------------------------- ;
LO_21b2                 sta HI_96a8                 ; 
                        jsr S_1e00                  ; 
                        rts                         ; 
; -------------------------------------------------------------------------------------------------------------- ;
ScreenStatusAmmoInc     jsr LO_3a5d                 ; 
                        jsr S_1e2d                  ; 
                        
                        rts                         ; 
; -------------------------------------------------------------------------------------------------------------- ;
LO_21c0                 sta HI_968a                 ; 
                        jsr LO_1e4b                 ; 
                        rts                         ; 
; -------------------------------------------------------------------------------------------------------------- ;
; S_21c7                Does    : 
;                       Expects : 
;                       Returns : 
; -------------------------------------------------------------------------------------------------------------- ;
S_21c7                  subroutine                  ; 
                        sta VCREG2                  ; SID($D40B) Oscillator 2 Control
                        lda #$81                    ; 
                        sta VCREG1                  ; SID($D404) Oscillator 1 Control
                        rts                         ; 
; -------------------------------------------------------------------------------------------------------------- ;
; SidSetCuthi           Does    : 
;                       Expects : 
;                       Returns : 
; -------------------------------------------------------------------------------------------------------------- ;
SidSetCuthi             subroutine                  ; 
                        sta CUTHI                   ; SID($D416) Filter Cutoff Frequency (high byte)
                        
                        lda T_2047                  ; 
                        sta HI_97ce                 ; 
                        
SidSetCuthiX            rts                         ; 
; -------------------------------------------------------------------------------------------------------------- ;
                        jsr GameInit                ; 
                        jsr S_1ea9                  ; 
                        
                        rts                         ; 
; -------------------------------------------------------------------------------------------------------------- ;
LO_21e1                 jsr LO_34f9                 ; 
                        jsr S_1ec7                  ; 
                        
                        rts                         ; 
; -------------------------------------------------------------------------------------------------------------- ;
LO_21e8                 inc HI_96b3                 ; 
                        lda #$c8                    ; 
                        sta FRELO1                  ; SID($D400) Oscillator 1 Freq Ctrl (low byte)
                        lda #$02                    ; 
                        sta FREHI1                  ; SID($D401) Oscillator 1 Freq Ctrl (high byte)
                        rts                         ; 
; -------------------------------------------------------------------------------------------------------------- ;
A_21f6                  dc.b $00 ; .hbu.
                        dc.b $7b ; 
                        dc.b $00 ; 
                        dc.b $7f ; 
                        dc.b $00 ; 
                        dc.b $7f ; 
                        dc.b $14 ; 
                        dc.b $77 ; 
                        dc.b $d9 ; 
                        dc.b $84 ; 
; -------------------------------------------------------------------------------------------------------------- ;
LO_2200                 jsr LO_2556                 ; 
                        lda #$09                    ; 
                        sta FREHI3                  ; SID($D40F) Oscillator 3 Freq Ctrl (high byte)
                        nop                         ; 
                        nop                         ; 
                        nop                         ; 
                        nop                         ; 
                        nop                         ; 
                        lda #$2c                    ; 
                        sta ATDCY3                  ; SID($D413) Oscillator 3 Attack/Decay
                        nop                         ; 
                        nop                         ; 
                        nop                         ; 
                        nop                         ; 
                        nop                         ; 
                        nop                         ; 
                        nop                         ; 
                        nop                         ; 
                        nop                         ; 
                        nop                         ; 
                        ldy #$80                    ; 
                        sty VCREG3                  ; SID($D412) Oscillator 3 Control
                        iny                         ; 
                        sty VCREG3                  ; SID($D412) Oscillator 3 Control
                        rts                         ; 
; -------------------------------------------------------------------------------------------------------------- ;
; S_2226                Does    : 
;                       Expects : 
;                       Returns : 
; -------------------------------------------------------------------------------------------------------------- ;
S_2226                  subroutine                  ; 
                        jsr LO_2556                 ; 
                        lda #$00                    ; 
                        sta FREHI3                  ; SID($D40F) Oscillator 3 Freq Ctrl (high byte)
                        lda #$00                    ; 
                        sta PWLO3                   ; SID($D410) Oscillator 3 Pulse Waveform Width (low byte)
                        lda #$08                    ; 
                        sta PWHI3                   ; SID($D411) Oscillator 3 Pulse Waveform Width (high nybble)
                        lda #$80                    ; 
                        sta SUREL3                  ; SID($D414) Oscillator 3 Sustain/Release
                        lda #$41                    ; 
                        sta VCREG3                  ; SID($D412) Oscillator 3 Control
                        rts                         ; 
; -------------------------------------------------------------------------------------------------------------- ;
LO_2243                 lda HI_9613                 ; 
                        asl a                       ; 
                        asl a                       ; 
                        asl a                       ; 
                        nop                         ; 
                        clc                         ; 
                        adc #$30                    ; 
                        sta FRELO3                  ; SID($D40E) Oscillator 3 Freq Ctrl (low byte)
                        lda #$00                    ; 
                        sta FREHI3                  ; SID($D40F) Oscillator 3 Freq Ctrl (high byte)
                        rts                         ; 
; -------------------------------------------------------------------------------------------------------------- ;
LO_2256                 jsr LO_254b                 ; 
                        nop                         ; 
                        nop                         ; 
                        nop                         ; 
                        nop                         ; 
                        nop                         ; 
                        nop                         ; 
                        nop                         ; 
                        nop                         ; 
                        nop                         ; 
                        nop                         ; 
                        lda HI_97cc                 ; 
                        sta ATDCY2                  ; SID($D40C) Oscillator 2 Attack/Decay
                        nop                         ; 
                        nop                         ; 
                        nop                         ; 
                        lda HI_97cd                 ; 
                        sta FREHI2                  ; SID($D408) Oscillator 2 Freq Ctrl (high byte)
                        lda #$81                    ; 
                        sta VCREG2                  ; SID($D40B) Oscillator 2 Control
                        rts                         ; 
; -------------------------------------------------------------------------------------------------------------- ;
; S_2278                Does    : 
;                       Expects : 
;                       Returns : 
; -------------------------------------------------------------------------------------------------------------- ;
S_2278                  subroutine                  ; 
                        lda GR_bed0,x               ; 
                        cmp #$02                    ; 
                        bcs B_2280                  ; 
B_227f                  rts                         ; 
; -------------------------------------------------------------------------------------------------------------- ;
B_2280                  cmp #$0e                    ; 
                        bcs B_227f                  ; 
                        asl a                       ; 
                        asl a                       ; 
                        nop                         ; 
                        nop                         ; 
                        sta HI_9729                 ; 
                        lda #$7d                    ; 
                        sec                         ; 
                        lda HI_9729                 ; 
                        nop                         ; 
                        nop                         ; 
                        nop                         ; 
                        nop                         ; 
                        nop                         ; 
                        nop                         ; 
                        nop                         ; 
                        rts                         ; 
; -------------------------------------------------------------------------------------------------------------- ;
; S_2299                Does    : 
;                       Expects : 
;                       Returns : 
; -------------------------------------------------------------------------------------------------------------- ;
S_2299                  subroutine                  ; 
                        jsr LO_254b                 ; 
                        jsr S_22d9                  ; 
                        nop                         ; 
                        nop                         ; 
                        nop                         ; 
                        nop                         ; 
                        nop                         ; 
                        nop                         ; 
                        nop                         ; 
                        nop                         ; 
                        nop                         ; 
                        nop                         ; 
                        nop                         ; 
                        nop                         ; 
                        nop                         ; 
                        nop                         ; 
                        nop                         ; 
                        nop                         ; 
                        nop                         ; 
                        nop                         ; 
                        lda #$01                    ; 
                        sta HI_97c9                 ; 
                        rts                         ; 
; -------------------------------------------------------------------------------------------------------------- ;
; S_22b7                Does    : 
;                       Expects : 
;                       Returns : 
; -------------------------------------------------------------------------------------------------------------- ;
S_22b7                  subroutine                  ; 
                        jsr LO_2540                 ; 
                        lda #$04                    ; 
                        sta FREHI1                  ; SID($D401) Oscillator 1 Freq Ctrl (high byte)
                        lda #$01                    ; 
                        sta PWHI1                   ; SID($D403) Oscillator 1 Pulse Waveform Width (high nybble)
                        lda #$bc                    ; 
                        sta ATDCY1                  ; SID($D405) Oscillator 1 Attack/Decay2
                        lda #$41                    ; 
                        sta VCREG1                  ; SID($D404) Oscillator 1 Control
                        nop                         ; 
                        nop                         ; 
                        nop                         ; 
                        nop                         ; 
                        nop                         ; 
                        nop                         ; 
                        nop                         ; 
                        nop                         ; 
                        nop                         ; 
                        nop                         ; 
                        rts                         ; 
; -------------------------------------------------------------------------------------------------------------- ;
; S_22d9                Does    : 
;                       Expects : 
;                       Returns : 
; -------------------------------------------------------------------------------------------------------------- ;
S_22d9                  subroutine                  ; 
                        jsr LO_2556                 ; 
                        lda #$20                    ; 
                        sta FRELO3                  ; SID($D40E) Oscillator 3 Freq Ctrl (low byte)
                        lda #$01                    ; 
                        sta FREHI3                  ; SID($D40F) Oscillator 3 Freq Ctrl (high byte)
                        lda #$c8                    ; 
                        sta PWLO3                   ; SID($D410) Oscillator 3 Pulse Waveform Width (low byte)
                        lda #$09                    ; 
                        sta PWHI3                   ; SID($D411) Oscillator 3 Pulse Waveform Width (high nybble)
                        lda #$20                    ; 
                        sta SUREL3                  ; SID($D414) Oscillator 3 Sustain/Release
                        lda #$41                    ; 
                        sta VCREG3                  ; SID($D412) Oscillator 3 Control
                        rts                         ; 
; -------------------------------------------------------------------------------------------------------------- ;
; S_22fb                Does    : 
;                       Expects : 
;                       Returns : 
; -------------------------------------------------------------------------------------------------------------- ;
S_22fb                  subroutine                  ; 
                        jsr S_22b7                  ; 
                        nop                         ; 
                        nop                         ; 
                        nop                         ; 
                        nop                         ; 
                        nop                         ; 
                        nop                         ; 
                        nop                         ; 
                        lda #$04                    ; .....#..
                        ora HI_97c9                 ; 
                        sta HI_97c9                 ; 
                        
U_230e                  equ * + $01                 ; 
                        lda #$82                    ; 
                        sta HI_97ca                 ; 
                        lda #$05                    ; 
                        sta HI_97cb                 ; 
                        lda #$01                    ; 
                        sta HI_96fd                 ; 
                        rts                         ; 
; -------------------------------------------------------------------------------------------------------------- ;
; S_231d                Does    : 
;                       Expects : 
;                       Returns : 
; -------------------------------------------------------------------------------------------------------------- ;
S_231d                  subroutine                  ; 
                        lda #$04                    ; 
                        
                        bit HI_97c9                 ; 
                        bne B_2325                  ; 
                        
B_2324                  rts                         ; 
                        
B_2325                  lda HI_96d5                 ; 
                        bne B_2324                  ; 
                        inc HI_96d5                 ; 
                        lda HI_97ca                 ; 
                        sec                         ; 
                        sbc #$02                    ; 
                        sta HI_97ca                 ; 
                        bcs B_233b                  ; 
                        dec HI_97cb                 ; 
B_233b                  lda HI_97cb                 ; 
                        cmp #$04                    ; 
                        bcs B_234b                  ; 
                        
                        lda #$fb                    ; #####.##
                        and HI_97c9                 ; 
                        sta HI_97c9                 ; 
                        
                        rts                         ; 
; -------------------------------------------------------------------------------------------------------------- ;
B_234b                  sta FREHI1                  ; SID($D401) Oscillator 1 Freq Ctrl (high byte)
                        sec                         ; 
                        sbc #$04                    ; 
                        clc                         ; 
                        ror a                       ; 
                        lda HI_97ca                 ; 
                        sta FRELO1                  ; SID($D400) Oscillator 1 Freq Ctrl (low byte)
                        ror a                       ; 
                        sta PWLO1                   ; SID($D402) Oscillator 1 Pulse Waveform Width (low byte)
                        rts                         ; 
; -------------------------------------------------------------------------------------------------------------- ;
LO_235e                 jsr S_2007                  ; 
                        jsr ScreenStatusShowScore   ; 
                        
                        rts                         ; 
; -------------------------------------------------------------------------------------------------------------- ;
; S_2365                Does    : 
;                       Expects : 
;                       Returns : 
; -------------------------------------------------------------------------------------------------------------- ;
S_2365                  subroutine                  ; 
                        jsr S_2b89                  ; 
                        jsr S_236c                  ; 
                        rts                         ; 
; -------------------------------------------------------------------------------------------------------------- ;
; S_236c                Does    : 
;                       Expects : 
;                       Returns : 
; -------------------------------------------------------------------------------------------------------------- ;
S_236c                  subroutine                  ; 
                        pha                         ; 
                        lda #$01                    ; 
                        
                        bit HI_97c9                 ; 
                        beq B_2385                  ; 
                        
                        jsr LO_2b74                 ; 
                        nop                         ; 
                        nop                         ; 
                        nop                         ; 
                        nop                         ; 
                        nop                         ; 
                        nop                         ; 
                        nop                         ; 
                        nop                         ; 
                        nop                         ; 
                        nop                         ; 
                        sta U_230e                  ; 
                        nop                         ; 
                        
B_2385                  pla                         ; 
                        rts                         ; 
; -------------------------------------------------------------------------------------------------------------- ;
; S_2387                Does    : 
;                       Expects : 
;                       Returns : 
; -------------------------------------------------------------------------------------------------------------- ;
S_2387                  subroutine                  ; 
                        jsr LO_2540                 ; 
                        lda #$28                    ; 
                        sta FREHI1                  ; SID($D401) Oscillator 1 Freq Ctrl (high byte)
                        lda #$0c                    ; 
                        sta ATDCY1                  ; SID($D405) Oscillator 1 Attack/Decay2
                        lda #$81                    ; 
                        sta VCREG1                  ; SID($D404) Oscillator 1 Control
                        
                        lda #$fb                    ; #####.##
                        and HI_97c9                 ; 
                        sta HI_97c9                 ; 
                        
                        rts                         ; 
; -------------------------------------------------------------------------------------------------------------- ;
; S_23a2                Does    : 
;                       Expects : 
;                       Returns : 
; -------------------------------------------------------------------------------------------------------------- ;
S_23a2                  subroutine                  ; 
                        lda #$fe                    ; #######.
                        and HI_97c9                 ; 
                        ora #$08                    ; ....#...
                        sta HI_97c9                 ; 
                        
                        lda #$06                    ; 
                        sta HI_96fe                 ; 
                        sta HI_96ae                 ; 
                        inc HI_96d6                 ; 
                        lda #$40                    ; 
                        sta HI_96ac                 ; 
                        sta HI_96d4                 ; 
                        rts                         ; 
; -------------------------------------------------------------------------------------------------------------- ;
; S_23c0                Does    : 
;                       Expects : 
;                       Returns : 
; -------------------------------------------------------------------------------------------------------------- ;
S_23c0                  subroutine                  ; 
                        lda #$08                    ; 
                        
                        bit HI_97c9                 ; 
                        bne B_23c8                  ; 
                        
B_23c7                  rts                         ; 
                        
B_23c8                  lda HI_96d6                 ; 
                        bne B_23c7                  ; 
                        inc HI_96d6                 ; 
                        lda HI_96d4                 ; 
                        beq B_23d9                  ; 
                        jsr S_23e7                  ; 
                        rts                         ; 
; -------------------------------------------------------------------------------------------------------------- ;
B_23d9                  lda #$f7                    ; ####.###
                        and HI_97c9                 ; 
                        ora #$01                    ; 
                        sta HI_97c9                 ; 
                        
                        jsr S_22d9                  ; 
                        rts                         ; 
; -------------------------------------------------------------------------------------------------------------- ;
; S_23e7                Does    : 
;                       Expects : 
;                       Returns : 
; -------------------------------------------------------------------------------------------------------------- ;
S_23e7                  subroutine                  ; 
                        jsr LO_2556                 ; 
                        lda #$20                    ; 
                        sta FREHI3                  ; SID($D40F) Oscillator 3 Freq Ctrl (high byte)
                        lda #$09                    ; 
                        sta ATDCY3                  ; SID($D413) Oscillator 3 Attack/Decay
                        lda #$81                    ; 
                        sta VCREG3                  ; SID($D412) Oscillator 3 Control
                        rts                         ; 
; -------------------------------------------------------------------------------------------------------------- ;
A_23fa                  dc.b $00 ; .hbu.
                        dc.b $00 ; 
                        dc.b $00 ; 
                        dc.b $00 ; 
                        dc.b $00 ; 
                        dc.b $00 ; 
; -------------------------------------------------------------------------------------------------------------- ;
LO_2400                 jsr LO_3784                 ; 
                        jsr LO_3781                 ; 
                        rts                         ; 
; -------------------------------------------------------------------------------------------------------------- ;
; S_2407                Does    : 
;                       Expects : 
;                       Returns : 
; -------------------------------------------------------------------------------------------------------------- ;
S_2407                  subroutine                  ; 
                        jsr S_2410                  ; 
                        jsr LO_2bdf                 ; 
                        rts                         ; 
; -------------------------------------------------------------------------------------------------------------- ;
                        nop                         ; 
                        nop                         ; 
; -------------------------------------------------------------------------------------------------------------- ;
; S_2410                Does    : 
;                       Expects : 
;                       Returns : 
; -------------------------------------------------------------------------------------------------------------- ;
S_2410                  subroutine                  ; 
                        lda BH_TabPlayerLives       ; 
                        cmp #$05                    ; 
                        bcs B_2418                  ; 
                        rts                         ; 
; -------------------------------------------------------------------------------------------------------------- ;
B_2418                  dec BH_TabPlayerLives       ; 
                        jsr ScreenStatusShowShips   ; 
                        
                        lda #$14                    ; 
                        sta HI_9740                 ; 
B_2423                  jsr ResetTOD                ; 
                        
B_2426                  lda TODTEN                  ; CIA1($DC08) Time of Day Clock Tenths
                        cmp #$01                    ; 
                        bcc B_2426                  ; 
                        jsr S_3772                  ; 
                        jsr ScreenStatusShowScore   ; 
                        jsr S_1f4c                  ; 
                        dec HI_9740                 ; 
                        lda HI_9740                 ; 
                        bne B_2423                  ; 
                        sta TODHRS                  ; CIA1($DC0B) Time of Day Clock Hours
                        jmp S_2410                  ; 
                        sta HI_972f                 ; 
                        lda #$01                    ; 
                        bit HI_9609                 ; 
                        bne B_2457                  ; 
                        lda #$06                    ; 
                        clc                         ; 
                        adc HI_972f                 ; 
                        sta HI_972f                 ; 
B_2457                  rts                         ; 
; -------------------------------------------------------------------------------------------------------------- ;
; SidInit               Does    : 
;                       Expects : 
;                       Returns : 
; -------------------------------------------------------------------------------------------------------------- ;
SidInit                 subroutine                  ; 
                        ldx #$17                    ; 
                        lda #$00                    ; 
.SetInit                sta SID,x                   ; SID($D400)
                        dex                         ; 
                        bpl .SetInit                ; 
                        
                        lda #$1f                    ; 
                        sta SIGVOL                  ; SID($D418) Volume/Filter Select
                        
SidInitX                rts                         ; 
; -------------------------------------------------------------------------------------------------------------- ;
; S_2468                Does    : 
;                       Expects : 
;                       Returns : 
; -------------------------------------------------------------------------------------------------------------- ;
S_2468                  subroutine                  ; 
                        lda #$01                    ; 
                        bit HI_97c9                 ; 
                        bne B_2470                  ; 
                        
B_246f                  rts                         ; 
                        
B_2470                  lda HI_96c2                 ; 
                        bne B_246f                  ; 
                        
                        inc HI_96c2                 ; 
                        
                        lda #$bb                    ; 
                        sta HI_969a                 ; 
                        
                        lda #$13                    ; 
                        sta SIGVOL                  ; SID($D418) Volume/Filter Select
                        lda #$00                    ; 
                        sta VCREG1                  ; SID($D404) Oscillator 1 Control
                        nop                         ; 
                        lda #$0c                    ; 
                        sta ATDCY1                  ; SID($D405) Oscillator 1 Attack/Decay2
                        lda #$20                    ; 
                        sta FRELO1                  ; SID($D400) Oscillator 1 Freq Ctrl (low byte)
                        lda #$60                    ; 
                        sta FREHI3                  ; SID($D40F) Oscillator 3 Freq Ctrl (high byte)
                        lda #$15                    ; 
                        sta VCREG1                  ; SID($D404) Oscillator 1 Control
                        
                        rts                         ; 
; -------------------------------------------------------------------------------------------------------------- ;
; SkillAndSidInit       Does    : 
;                       Expects : 
;                       Returns : 
; -------------------------------------------------------------------------------------------------------------- ;
SkillAndSidInit         subroutine                  ; 
                        jsr SkillLevelInit          ; 
                        jsr SidInit                 ; 
                        
SkillAndSidInitX        rts                         ; 
; -------------------------------------------------------------------------------------------------------------- ;
; S_24a4                Does    : 
;                       Expects : 
;                       Returns : 
; -------------------------------------------------------------------------------------------------------------- ;
S_24a4                  subroutine                  ; 
                        jsr HI_6b5b                 ; 
                        jsr S_2468                  ; 
                        
                        rts                         ; 
; -------------------------------------------------------------------------------------------------------------- ;
; GoSpriteDataCopyInit  Does    : 
;                       Expects : 
;                       Returns : 
; -------------------------------------------------------------------------------------------------------------- ;
GoSpriteDataCopyInit    subroutine                  ; 
                        jsr SpriteDataCopyInit      ; 
                        
                        lda #$01                    ; 
                        sta HI_97c9                 ; 
                        
GoSpriteDataCopyInitX   rts                         ; 
; -------------------------------------------------------------------------------------------------------------- ;
; S_24b4                Does    : 
;                       Expects : 
;                       Returns : 
; -------------------------------------------------------------------------------------------------------------- ;
S_24b4                  subroutine                  ; 
                        lda #$02                    ; 
                        
                        bit HI_97c9                 ; 
                        bne B_24bc                  ; 
                        
B_24bb                  rts                         ; 
                        
B_24bc                  lda HI_96c2                 ; 
                        bne B_24bb                  ; 
                        
                        inc HI_96c2                 ; 
                        
                        lda #$1e                    ; 
                        sta HI_969a                 ; 
                        lda #$00                    ; 
                        sta VCREG1                  ; SID($D404) Oscillator 1 Control
                        lda #$0e                    ; 
                        sta FREHI1                  ; SID($D401) Oscillator 1 Freq Ctrl (high byte)
                        lda #$24                    ; 
                        sta FRELO3                  ; SID($D40E) Oscillator 3 Freq Ctrl (low byte)
                        lda #$0c                    ; 
                        sta ATDCY1                  ; SID($D405) Oscillator 1 Attack/Decay2
                        lda #$6b                    ; 
                        sta FRELO1                  ; SID($D400) Oscillator 1 Freq Ctrl (low byte)
                        lda #$30                    ; 
                        sta FREHI3                  ; SID($D40F) Oscillator 3 Freq Ctrl (high byte)
                        lda #$15                    ; 
                        sta VCREG1                  ; SID($D404) Oscillator 1 Control
                        
                        rts                         ; 
; -------------------------------------------------------------------------------------------------------------- ;
; S_24ed                Does    : 
;                       Expects : 
;                       Returns : 
; -------------------------------------------------------------------------------------------------------------- ;
S_24ed                  subroutine                  ; 
                        lda #$02                    ; 
                        jsr S_259a                  ; 
                        jsr ResetTOD                ; 
B_24f5                  jsr S_24b4                  ; 
                        lda TODSEC                  ; CIA1($DC09) Time of Day Clock Seconds
                        cmp #$03                    ; 
                        bcc B_24f5                  ; 
                        sta TODHRS                  ; CIA1($DC0B) Time of Day Clock Hours
                        nop                         ; 
                        nop                         ; 
                        
                        lda #$fd                    ; ######.#
                        and HI_97c9                 ; 
                        sta HI_97c9                 ; 
                        
                        jsr S_2510                  ; 
                        rts                         ; 
; -------------------------------------------------------------------------------------------------------------- ;
; S_2510                Does    : 
;                       Expects : 
;                       Returns : 
; -------------------------------------------------------------------------------------------------------------- ;
S_2510                  subroutine                  ; 
                        ldx #$01                    ; 
                        lda #$00                    ; 
B_2514                  sta FRELO1,x                ; SID($D400) Oscillator 1 Freq Ctrl (low byte)
                        sta FRELO2,x                ; SID($D407) Oscillator 2 Freq Ctrl (low byte)
                        sta FRELO3,x                ; SID($D40E) Oscillator 3 Freq Ctrl (low byte)
                        dex                         ; 
                        bpl B_2514                  ; 
                        
                        rts                         ; 
; -------------------------------------------------------------------------------------------------------------- ;
LO_2521                 jsr S_24ed                  ; 
                        
                        jmp BH_ChapCaveCrossings    ; 
; -------------------------------------------------------------------------------------------------------------- ;
LO_2527                 sta HI_960b                 ; 
                        jsr S_24ed                  ; 
                        
                        rts                         ; 
; -------------------------------------------------------------------------------------------------------------- ;
LO_252e                 jsr S_24ed                  ; 
                        jmp HI_811a                 ; 
; -------------------------------------------------------------------------------------------------------------- ;
; S_2534                Does    : 
;                       Expects : 
;                       Returns : 
; -------------------------------------------------------------------------------------------------------------- ;
S_2534                  subroutine                  ; 
                        ora HI_97c9                 ; 
                        sta HI_97c9                 ; 
                        
                        lda #$01                    ; 
                        jmp J_2591                  ; 
; -------------------------------------------------------------------------------------------------------------- ;
A_253f                  dc.b $a9 ; 
; -------------------------------------------------------------------------------------------------------------- ;
; LO_2540               Does    : 
;                       Expects : 
;                       Returns : 
; -------------------------------------------------------------------------------------------------------------- ;
LO_2540                 subroutine                  ; 
                        ldy #$06                    ; 
                        lda #$00                    ; 
B_2544                  sta FRELO1,y                ; SID($D400) Oscillator 1 Freq Ctrl (low byte)
                        dey                         ; 
                        bpl B_2544                  ; 
                        rts                         ; 
; -------------------------------------------------------------------------------------------------------------- ;
; LO_254b               Does    : 
;                       Expects : 
;                       Returns : 
; -------------------------------------------------------------------------------------------------------------- ;
LO_254b                 subroutine                  ; 
                        ldy #$06                    ; 
                        lda #$00                    ; 
B_254f                  sta FRELO2,y                ; SID($D407) Oscillator 2 Freq Ctrl (low byte)
                        dey                         ; 
                        bpl B_254f                  ; 
                        rts                         ; 
; -------------------------------------------------------------------------------------------------------------- ;
; LO_2556               Does    : 
;                       Expects : 
;                       Returns : 
; -------------------------------------------------------------------------------------------------------------- ;
LO_2556                 subroutine                  ; 
                        ldy #$06                    ; 
                        lda #$00                    ; 
B_255a                  sta FRELO3,y                ; SID($D40E) Oscillator 3 Freq Ctrl (low byte)
                        dey                         ; 
                        bpl B_255a                  ; 
                        rts                         ; 
; -------------------------------------------------------------------------------------------------------------- ;
; SidInitVoc2           Does    : 
;                       Expects : 
;                       Returns : 
; -------------------------------------------------------------------------------------------------------------- ;
SidInitVoc2             subroutine                  ; 
                        jsr SidInit                 ; 
                        
                        lda #$50                    ; 
                        sta SUREL2                  ; SID($D40D) Oscillator 2 Sustain/Release
                        lda #$81                    ; 
                        sta VCREG2                  ; SID($D40B) Oscillator 2 Control
                        
SidInitVoc2X            rts                         ; 
; -------------------------------------------------------------------------------------------------------------- ;
; S_256f                Does    : 
;                       Expects : 
;                       Returns : 
; -------------------------------------------------------------------------------------------------------------- ;
S_256f                  subroutine                  ; 
                        lda HI_9670                 ; 
                        ora HI_9678                 ; 
                        beq B_257d                  ; 
                        lda #$f0                    ; 
                        sta FREHI2                  ; SID($D408) Oscillator 2 Freq Ctrl (high byte)
                        rts                         ; 
; -------------------------------------------------------------------------------------------------------------- ;
B_257d                  lda #$00                    ; 
                        sta FREHI2                  ; SID($D408) Oscillator 2 Freq Ctrl (high byte)
                        rts                         ; 
; -------------------------------------------------------------------------------------------------------------- ;
MapSetSpritesSound      jsr GoSpriteDataCopyInit    ; 
                        jsr SidInitVoc2             ; 
                        
MapSetSpritesSoundX     rts                         ; 
; -------------------------------------------------------------------------------------------------------------- ;
MapBlinkTargetsPing     jsr S_24a4                  ; 
                        jsr S_256f                  ; 
                        
                        rts                         ; 
; -------------------------------------------------------------------------------------------------------------- ;
J_2591                  sta HI_969a                 ; 
                        lda #$03                    ; 
                        sta SIGVOL                  ; SID($D418) Volume/Filter Select
                        rts                         ; 
; -------------------------------------------------------------------------------------------------------------- ;
; S_259a                Does    : 
;                       Expects : 
;                       Returns : 
; -------------------------------------------------------------------------------------------------------------- ;
S_259a                  subroutine                  ; 
                        jsr S_2510                  ; 
                        lda #$02                    ; 
                        jsr S_2534                  ; 
                        rts                         ; 
; -------------------------------------------------------------------------------------------------------------- ;
; S_25a3                Does    : 
;                       Expects : 
;                       Returns : 
; -------------------------------------------------------------------------------------------------------------- ;
S_25a3                  subroutine                  ; 
                        nop                         ; 
                        nop                         ; 
                        nop                         ; 
                        nop                         ; 
                        nop                         ; 
                        lda #$15                    ; 
                        sta FREHI1                  ; SID($D401) Oscillator 1 Freq Ctrl (high byte)
                        nop                         ; 
                        nop                         ; 
                        nop                         ; 
                        nop                         ; 
                        nop                         ; 
                        lda #$8a                    ; 
                        sta ATDCY1                  ; SID($D405) Oscillator 1 Attack/Decay2
                        lda #$00                    ; 
                        sta SUREL1                  ; SID($D406) Oscillator 1 Sustain/Release
                        ldy #$80                    ; 
                        sty VCREG1                  ; SID($D404) Oscillator 1 Control
                        iny                         ; 
                        sty VCREG1                  ; SID($D404) Oscillator 1 Control
                        rts                         ; 
; -------------------------------------------------------------------------------------------------------------- ;
LO_25c6                 nop                         ; 
                        nop                         ; 
                        nop                         ; 
                        jsr S_25a3                  ; 
                        jsr HI_6dc7                 ; 
                        rts                         ; 
; -------------------------------------------------------------------------------------------------------------- ;
LO_25d0                 jsr HI_6d3e                 ; 
                        jsr S_25a3                  ; 
                        rts                         ; 
; -------------------------------------------------------------------------------------------------------------- ;
                        sta RESON                   ; SID($D417) Filter Resonance Ctrl
                        lda #$00                    ; 
                        sta SUREL1                  ; SID($D406) Oscillator 1 Sustain/Release
                        rts                         ; 
; -------------------------------------------------------------------------------------------------------------- ;
LO_25e0                 sta BH_SpritePointer00      ; 
                        jsr S_2226                  ; 
                        
                        rts                         ; 
; -------------------------------------------------------------------------------------------------------------- ;
                        inc GR_bed0,x               ; 
                        jsr S_2278                  ; 
                        rts                         ; 
; -------------------------------------------------------------------------------------------------------------- ;
LO_25ee                 sta HI_97bb                 ; 
                        jsr S_2299                  ; 
                        rts                         ; 
; -------------------------------------------------------------------------------------------------------------- ;
; S_25f5                Does    : 
;                       Expects : 
;                       Returns : 
; -------------------------------------------------------------------------------------------------------------- ;
S_25f5                  subroutine                  ; 
                        jsr S_22fb                  ; 
                        lda SP4X                    ; VIC($D008) Sprite 4 X-Pos (Bits 0-7 - Bit 8 in MSIGX = $D010)
                        cmp #$c0                    ; 
                        rts                         ; 
; -------------------------------------------------------------------------------------------------------------- ;
A_25fe                  dc.b $8c ; 
                        dc.b $12 ; 
; -------------------------------------------------------------------------------------------------------------- ;
LO_2600                 ldx #$07                    ; 
B_2602                  lda HI_9718,x               ; 
                        bne B_260a                  ; 
                        
                        jsr S_264a                  ; 
B_260a                  jmp HI_8e63                 ; 
; -------------------------------------------------------------------------------------------------------------- ;
LO_260d                 bne B_2612                  ; 
                        
                        jsr S_26a7                  ; 
                        
B_2612                  lda HI_9720,x               ; 
                        cmp #$01                    ; 
                        bne B_261c                  ; 
                        
                        jsr S_26cb                  ; 
                        
B_261c                  lda HI_9720,x               ; 
                        cmp #$02                    ; 
                        bne B_2626                  ; 
                        
                        jsr S_270c                  ; 
                        
B_2626                  lda HI_9720,x               ; 
                        cmp #$03                    ; 
                        bne B_2630                  ; 
                        
                        jsr S_2731                  ; 
                        
B_2630                  lda HI_9720,x               ; 
                        cmp #$04                    ; 
                        bne B_263a                  ; 
                        
                        jsr S_27bd                  ; 
                        
B_263a                  lda HI_9720,x               ; 
                        cmp #$05                    ; 
                        bne LO_2644                  ; 
                        
                        jsr S_2866                  ; 
                        
LO_2644                 dex                         ; 
                        cpx #$04                    ; 
                        bne B_2602                  ; 
                        
                        rts                         ; 
; -------------------------------------------------------------------------------------------------------------- ;
; S_264a                Does    : 
;                       Expects : 
;                       Returns : 
; -------------------------------------------------------------------------------------------------------------- ;
S_264a                  subroutine                  ; 
                        jsr SetYrToXrMult2          ; yr = xr * 2
                        lda #$a8                    ; 
                        jsr HI_8f81                 ; 
                        
                        lda #$8c                    ; 
                        sta SP0Y,y                  ; VIC($D001) Sprite 0 Y-Pos (Bits 0-7)
                        lda #$00                    ; 
                        sta SP0COL,x                ; VIC($D027) Color Sprite 0
                        lda YXPAND                  ; VIC($D017) Sprite Scale Double Width
                        and #$0f                    ; ....####
                        sta YXPAND                  ; VIC($D017) Sprite Scale Double Width
                        lda XXPAND                  ; VIC($D01D) Sprite Double Height
                        and #$0f                    ; ....####
                        sta XXPAND                  ; VIC($D01D) Sprite Double Height
                        
                        lda #$40                    ; 
                        sta BH_SpritePointers,x     ; 
                        jsr LO_34f9                 ; 
                        
                        lda #$01                    ; 
                        sta HI_9718,x               ; 
                        lda #$01                    ; 
                        sta HI_9798,x               ; 
                        lda #$90                    ; 
                        sta HI_9700,x               ; 
                        lda #$01                    ; 
                        sta HI_9658,x               ; 
                        lda #$02                    ; 
                        sta HI_9708,x               ; 
                        lda #$01                    ; 
                        sta HI_9660,x               ; 
                        lda #$00                    ; 
                        jsr HI_8ee6                 ; 
                        lda #$00                    ; 
                        sta GR_bed0,x               ; 
                        lda #$06                    ; 
                        sta HI_96e0,x               ; 
                        lda #$00                    ; 
                        sta HI_9720,x               ; 
                        
                        rts                         ; 
; -------------------------------------------------------------------------------------------------------------- ;
; S_26a7                Does    : 
;                       Expects : 
;                       Returns : 
; -------------------------------------------------------------------------------------------------------------- ;
S_26a7                  subroutine                  ; 
                        jsr SetYrToXrMult2          ; yr = xr * 2
                        lda SP0X,y                  ; VIC($D000) Sprite 0 X-Pos (Bits 0-7 - Bit 8 in MSIGX = $D010)
                        cmp #$84                    ; 
                        bcs B_26ca                  ; 
                        lda #$00                    ; 
                        sta HI_9670,x               ; 
                        lda #$03                    ; 
                        sta HI_9658,x               ; 
                        lda #$02                    ; 
                        sta HI_9710,x               ; 
                        lda #$01                    ; 
                        sta HI_9668,x               ; 
                        lda #$01                    ; 
                        sta HI_9720,x               ; 
B_26ca                  rts                         ; 
; -------------------------------------------------------------------------------------------------------------- ;
; S_26cb                Does    : 
;                       Expects : 
;                       Returns : 
; -------------------------------------------------------------------------------------------------------------- ;
S_26cb                  subroutine                  ; 
                        lda HI_9700,x               ; 
                        and #$7f                    ; 
                        beq B_26d3                  ; 
                        rts                         ; 
; -------------------------------------------------------------------------------------------------------------- ;
B_26d3                  jsr HI_8f37                 ; 
                        jsr S_2b98                  ; 
                        sec                         ; 
                        sbc SP0X,y                  ; VIC($D000) Sprite 0 X-Pos (Bits 0-7 - Bit 8 in MSIGX = $D010)
                        bcs B_26e6                  ; 
                        jsr HI_8f40                 ; 
                        adc #$01                    ; 
                        nop                         ; 
                        lsr a                       ; 
B_26e6                  lsr a                       ; 
                        lsr a                       ; 
                        sta HI_9670,x               ; 
                        jsr S_2365                  ; 
                        sta HI_975e                 ; 
                        jsr SetYrToXrMult2          ; yr = xr * 2
                        lda SP0Y,y                  ; VIC($D001) Sprite 0 Y-Pos (Bits 0-7)
                        sec                         ; 
                        jsr HI_8ec3                 ; 
                        lsr a                       ; 
                        lsr a                       ; 
                        lsr a                       ; 
                        sta HI_9708,x               ; 
                        lda #$03                    ; 
                        sta HI_9710,x               ; 
                        lda #$02                    ; 
                        sta HI_9720,x               ; 
                        rts                         ; 
; -------------------------------------------------------------------------------------------------------------- ;
; S_270c                Does    : 
;                       Expects : 
;                       Returns : 
; -------------------------------------------------------------------------------------------------------------- ;
S_270c                  subroutine                  ; 
                        lda GR_bed0,x               ; 
                        nop                         ; 
                        nop                         ; 
                        nop                         ; 
                        cmp #$05                    ; 
                        bcs B_2717                  ; 
                        rts                         ; 
; -------------------------------------------------------------------------------------------------------------- ;
B_2717                  lda #$0c                    ; 
                        sta HI_9678,x               ; 
                        lda #$1e                    ; 
                        sta HI_96f0,x               ; 
                        lda #$02                    ; 
                        sta HI_9660,x               ; 
                        lda #$03                    ; 
                        sta HI_9720,x               ; 
                        
                        lda #$41                    ; 
                        sta BH_SpritePointers,x     ; 
                        
                        rts                         ; 
; -------------------------------------------------------------------------------------------------------------- ;
; S_2731                Does    : 
;                       Expects : 
;                       Returns : 
; -------------------------------------------------------------------------------------------------------------- ;
S_2731                  subroutine                  ; 
                        lda GR_bed0,x               ; 
                        cmp #$0b                    ; 
                        beq B_273f                  ; 
                        
                        clc                         ; 
                        adc #$3c                    ; 
                        sta BH_SpritePointers,x     ; 
                        
                        rts                         ; 
                        
B_273f                  jsr SetYrToXrMult2          ; yr = xr * 2
                        
                        lda SP0Y,y                  ; VIC($D001) Sprite 0 Y-Pos (Bits 0-7)
                        sta SP4Y                    ; VIC($D009) Sprite 4 Y-Pos (Bits 0-7)
                        
                        lda SP0X,y                  ; VIC($D000) Sprite 0 X-Pos (Bits 0-7 - Bit 8 in MSIGX = $D010)
                        clc                         ; 
                        adc #$0c                    ; 
                        sta SP4X                    ; VIC($D008) Sprite 4 X-Pos (Bits 0-7 - Bit 8 in MSIGX = $D010)
                        
                        jmp HI_8e83                 ; 
; -------------------------------------------------------------------------------------------------------------- ;
A_2754                  dc.b $10 ; .hbu.
                        dc.b $0d ; 
                        dc.b $10 ; 
                        dc.b $d0 ; 
; -------------------------------------------------------------------------------------------------------------- ;
                        sta MSIGX                   ; VIC($D010) MSB X-Pos Sprites 0-7
LO_275b                 lda SP0X,y                  ; VIC($D000) Sprite 0 X-Pos (Bits 0-7 - Bit 8 in MSIGX = $D010)
                        sec                         ; 
                        sbc #$0c                    ; 
                        sta SP0X,y                  ; VIC($D000) Sprite 0 X-Pos (Bits 0-7 - Bit 8 in MSIGX = $D010)
                        bcs B_276f                  ; 
                        
                        jsr LO_350f                 ; 
                        eor MSIGX                   ; VIC($D010) MSB X-Pos Sprites 0-7
                        sta MSIGX                   ; VIC($D010) MSB X-Pos Sprites 0-7
B_276f                  nop                         ; 
                        
                        lda #$47                    ; 
                        sta BH_SpritePointers,x     ; 
                        
                        lda #$48                    ; 
                        sta BH_SpritePointer04      ; 
                        
                        lda HI_9700,x               ; 
                        sta HI_9704                 ; 
                        lda HI_9708,x               ; 
                        sta HI_970c                 ; 
                        lda HI_9710,x               ; 
                        sta HI_9714                 ; 
                        lda HI_9658,x               ; 
                        sta HI_965c                 ; 
                        lda HI_9660,x               ; 
                        sta HI_9664                 ; 
                        lda HI_9668,x               ; 
                        sta HI_966c                 ; 
                        lda HI_9670,x               ; 
                        sta HI_9674                 ; 
                        lda HI_9678,x               ; 
                        sta HI_967c                 ; 
                        lda #$04                    ; 
                        sta HI_9720,x               ; 
                        
                        lda #$10                    ; ...#....
                        ora SPENA                   ; VIC($D015) Sprite Enable Register
                        
                        jsr HI_8f53                 ; 
                        lda #$00                    ; 
                        sta SP4COL                  ; VIC($D02B) Color Sprite 4
                        rts                         ; 
; -------------------------------------------------------------------------------------------------------------- ;
; S_27bd                Does    : 
;                       Expects : 
;                       Returns : 
; -------------------------------------------------------------------------------------------------------------- ;
S_27bd                  subroutine                  ; 
                        lda GR_bed0,x               ; 
                        cmp #$10                    ; 
                        beq B_27d4                  ; 
                        
                        asl a                       ; 
                        clc                         ; 
                        adc #$31                    ; 
                        sta BH_SpritePointers,x     ; 
                        
                        adc #$01                    ; 
                        sta BH_SpritePointer04      ; 
                        
                        jsr S_200e                  ; 
                        
                        rts                         ; 
                        
B_27d4                  jsr S_25f5                  ; 
                        nop                         ; 
                        nop                         ; 
                        bcc B_280d                  ; 
                        lda #$03                    ; 
                        sta HI_97be                 ; 
                        lda #$1e                    ; 
                        sta HI_9700,x               ; 
                        sta HI_9704                 ; 
                        lda #$1e                    ; 
                        sta HI_9708,x               ; 
                        sta HI_970c                 ; 
                        lda #$01                    ; 
                        sta HI_9658,x               ; 
                        sta HI_965c                 ; 
                        lda #$01                    ; 
                        sta HI_9660,x               ; 
                        sta HI_9664                 ; 
                        
                        lda #$5d                    ; 
                        sta BH_SpritePointers,x     ; 
                        
                        lda #$5e                    ; 
                        sta BH_SpritePointer04      ; 
                        jmp J_2860                  ; 
B_280d                  lda SP4X                    ; VIC($D008) Sprite 4 X-Pos (Bits 0-7 - Bit 8 in MSIGX = $D010)
                        cmp #$80                    ; 
                        bcc B_2836                  ; 
                        lda #$02                    ; 
                        sta HI_97be                 ; 
                        lda #$1e                    ; 
                        sta HI_9708,x               ; 
                        sta HI_970c                 ; 
                        lda #$01                    ; 
                        sta HI_9660,x               ; 
                        sta HI_9664                 ; 
                        
                        lda #$51                    ; 
                        sta BH_SpritePointers,x     ; 
                        
                        lda #$52                    ; 
                        sta BH_SpritePointer04      ; 
                        jmp J_2860                  ; 
B_2836                  lda #$b0                    ; 
                        sta HI_9700,x               ; 
                        sta HI_9704                 ; 
                        lda #$1e                    ; 
                        sta HI_9708,x               ; 
                        jsr HI_8f4a                 ; 
                        lda #$01                    ; 
                        sta HI_9658,x               ; 
                        sta HI_965c                 ; 
                        lda #$01                    ; 
                        sta HI_9660,x               ; 
                        sta HI_9664                 ; 
                        
                        lda #$57                    ; 
                        sta BH_SpritePointers,x     ; 
                        
                        lda #$58                    ; 
                        sta BH_SpritePointer04      ; 
J_2860                  lda #$05                    ; 
                        sta HI_9720,x               ; 
                        rts                         ; 
; -------------------------------------------------------------------------------------------------------------- ;
; S_2866                Does    : 
;                       Expects : 
;                       Returns : 
; -------------------------------------------------------------------------------------------------------------- ;
S_2866                  subroutine                  ; 
                        lda HI_9700,x               ; 
                        bpl B_2878                  ; 
                        
                        jsr SetYrToXrMult2          ; yr = xr * 2
                        lda SP0X,y                  ; VIC($D000) Sprite 0 X-Pos (Bits 0-7 - Bit 8 in MSIGX = $D010)
                        cmp #$02                    ; 
                        bcc LO_28c0                 ; 
                        
                        jmp J_288a                  ; 
                        
B_2878                  jsr LO_350f                 ; 
                        
                        bit MSIGX                   ; VIC($D010) MSB X-Pos Sprites 0-7
                        beq J_288a                  ; 
                        jsr SetYrToXrMult2          ; yr = xr * 2
                        lda SP0X,y                  ; VIC($D000) Sprite 0 X-Pos (Bits 0-7 - Bit 8 in MSIGX = $D010)
                        cmp #$70                    ; 
                        bcs LO_28c0                 ; 
J_288a                  jmp HI_8eed                 ; 
LO_288f                 equ * + $02                 ; .hbu. - obsolete
                        lda SP0Y,y                  ; VIC($D001) Sprite 0 Y-Pos (Bits 0-7)
                        cmp #$3c                    ; 
                        bcc LO_28c0                 ; 
                        lda GR_bed0,x               ; 
                        cmp #$13                    ; 
LO_2899                 ldy #$3e                    ; 
                        jmp J_28b5                  ; 
                        
LO_289e                 cmp #$02                    ; 
                        bne B_28ad                  ; 
                        jsr HI_8ea3                 ; 
                        sta BH_SpritePointers,x     ; 
                        
                        ldy #$32                    ; 
                        jmp J_28b5                  ; 
B_28ad                  jsr HI_8eab                 ; 
                        sta BH_SpritePointers,x     ; 
                        
                        ldy #$38                    ; 
J_28b5                  nop                         ; 
                        clc                         ; 
                        adc #$01                    ; 
                        sta BH_SpritePointer04      ; 
LO_28bc                 jsr LO_28db                 ; 
                        rts                         ; 
; -------------------------------------------------------------------------------------------------------------- ;
LO_28c0                 jsr LO_3503                 ; 
                        
                        lda #$ff                    ; 
                        jsr HI_8fbb                 ; 
                        
                        lda #$00                    ; 
                        sta HI_9798,x               ; 
                        
                        lda #$ef                    ; ###.####
                        and SPENA                   ; VIC($D015) Sprite Enable Register
                        sta SPENA                   ; VIC($D015) Sprite Enable Register
                        
                        lda #$ff                    ; 
                        sta HI_9718,x               ; 
                        
                        rts                         ; 
; -------------------------------------------------------------------------------------------------------------- ;
; LO_28db               Does    : 
;                       Expects : 
;                       Returns : 
; -------------------------------------------------------------------------------------------------------------- ;
LO_28db                 subroutine                  ; 
                        jsr HI_8f5a                 ; 
                        lda SP0X,y                  ; VIC($D000) Sprite 0 X-Pos (Bits 0-7 - Bit 8 in MSIGX = $D010)
                        clc                         ; 
                        adc #$18                    ; 
                        sta SP4X                    ; VIC($D008) Sprite 4 X-Pos (Bits 0-7 - Bit 8 in MSIGX = $D010)
                        bcc B_28f1                  ; 
                        lda #$10                    ; 
                        ora MSIGX                   ; VIC($D010) MSB X-Pos Sprites 0-7
                        sta MSIGX                   ; VIC($D010) MSB X-Pos Sprites 0-7
B_28f1                  lda SP0Y,y                  ; VIC($D001) Sprite 0 Y-Pos (Bits 0-7)
                        jsr HI_8f75                 ; 
                        rts                         ; 
; -------------------------------------------------------------------------------------------------------------- ;
LO_28f8                 ldx #$07                    ; 
LO_28fa                 lda HI_9658,x               ; 
                        bne B_2907                  ; 
                        lda #$00                    ; 
                        sta HI_9700,x               ; 
                        jmp J_296f                  ; 
B_2907                  cmp #$01                    ; 
                        bne B_290e                  ; 
                        jmp J_296f                  ; 
B_290e                  cmp #$02                    ; 
                        bne B_292f                  ; 
                        lda #$80                    ; 
                        ora HI_9700,x               ; 
                        sta HI_9700,x               ; 
J_291a                  lda HI_96b8,x               ; 
                        bne J_296f                  ; 
                        lda HI_9700,x               ; 
                        and #$7f                    ; 
                        cmp HI_9670,x               ; 
                        bcs J_296f                  ; 
                        inc HI_9700,x               ; 
                        jmp J_296f                  ; 
B_292f                  cmp #$03                    ; 
                        bne B_2951                  ; 
                        lda #$80                    ; 
                        ora HI_9700,x               ; 
                        sta HI_9700,x               ; 
J_293b                  lda HI_96b8,x               ; 
                        bne J_296f                  ; 
                        lda HI_9700,x               ; 
                        and #$7f                    ; 
                        cmp #$00                    ; 
                        beq J_296f                  ; 
                        bcc J_296f                  ; 
                        dec HI_9700,x               ; 
                        jmp J_296f                  ; 
B_2951                  cmp #$04                    ; 
                        bne B_2960                  ; 
                        lda #$7f                    ; 
                        and HI_9700,x               ; 
                        sta HI_9700,x               ; 
                        jmp J_291a                  ; 
B_2960                  cmp #$05                    ; 
                        bne B_2979                  ; 
                        lda #$7f                    ; 
                        and HI_9700,x               ; 
                        sta HI_9700,x               ; 
                        jmp J_293b                  ; 
J_296f                  lda HI_96b8,x               ; 
                        bne B_2979                  ; 
                        lda #$01                    ; 
                        sta HI_96b8,x               ; 
B_2979                  lda HI_9660,x               ; 
                        bne B_2986                  ; 
                        lda #$00                    ; 
                        sta HI_9708,x               ; 
                        jmp J_29ee                  ; 
B_2986                  cmp #$01                    ; 
                        bne B_298d                  ; 
                        jmp J_29ee                  ; 
B_298d                  cmp #$02                    ; 
                        bne B_29ae                  ; 
                        lda #$7f                    ; 
                        and HI_9708,x               ; 
                        sta HI_9708,x               ; 
J_2999                  lda HI_96c8,x               ; 
                        bne J_29ee                  ; 
                        lda HI_9708,x               ; 
                        and #$7f                    ; 
                        cmp HI_9678,x               ; 
                        bcs J_29ee                  ; 
                        inc HI_9708,x               ; 
                        jmp J_29ee                  ; 
B_29ae                  cmp #$03                    ; 
                        bne B_29d0                  ; 
                        lda #$7f                    ; 
                        and HI_9708,x               ; 
                        sta HI_9708,x               ; 
J_29ba                  lda HI_96c8,x               ; 
                        bne J_29ee                  ; 
                        lda HI_9708,x               ; 
                        and #$7f                    ; 
                        cmp #$00                    ; 
                        beq J_29ee                  ; 
                        bcc J_29ee                  ; 
                        dec HI_9708,x               ; 
                        jmp J_29ee                  ; 
B_29d0                  cmp #$04                    ; 
                        bne B_29df                  ; 
                        lda #$80                    ; 
                        ora HI_9708,x               ; 
                        sta HI_9708,x               ; 
                        jmp J_2999                  ; 
B_29df                  cmp #$05                    ; 
                        bne B_29f8                  ; 
                        lda #$80                    ; 
                        ora HI_9708,x               ; 
                        sta HI_9708,x               ; 
                        jmp J_29ba                  ; 
J_29ee                  lda HI_96c8,x               ; 
                        bne B_29f8                  ; 
                        lda #$01                    ; 
                        sta HI_96c8,x               ; 
B_29f8                  lda HI_9668,x               ; 
                        bne B_2a05                  ; 
                        lda #$00                    ; 
                        sta HI_9710,x               ; 
                        jmp J_2a09                  ; 
B_2a05                  cmp #$01                    ; 
                        bne J_2a09                  ; 
J_2a09                  jmp HI_8f6c                 ; 
                        jmp LO_28fa                 ; 
                        rts                         ; 
; -------------------------------------------------------------------------------------------------------------- ;
                        rts                         ; 
; -------------------------------------------------------------------------------------------------------------- ;
LO_2a11                 ldx HI_97b9                 ; 
                        lda GR_bed0,x               ; 
                        cmp #$05                    ; 
                        bcs B_2a1c                  ; 
                        rts                         ; 
; -------------------------------------------------------------------------------------------------------------- ;
B_2a1c                  jmp HI_8fdd                 ; 
                        bne LO_2a23                 ; 
                        ldx #$05                    ; 
LO_2a23                 stx HI_97b9                 ; 
                        lda HI_97ba                 ; 
                        beq B_2a31                  ; 
                        dec HI_97ba                 ; 
                        jmp J_2a43                  ; 
B_2a31                  cpx #$05                    ; 
                        bne J_2a43                  ; 
                        lda #$06                    ; 
                        jsr HI_8fe2                 ; 
                        lda #$00                    ; 
                        sta GR_bed0,x               ; 
                        jsr S_2a49                  ; 
                        rts                         ; 
; -------------------------------------------------------------------------------------------------------------- ;
J_2a43                  lda #$00                    ; 
                        sta HI_9718,x               ; 
                        rts                         ; 
; -------------------------------------------------------------------------------------------------------------- ;
; S_2a49                Does    : 
;                       Expects : 
;                       Returns : 
; -------------------------------------------------------------------------------------------------------------- ;
S_2a49                  subroutine                  ; 
                        lda #$01                    ; 
                        sta HI_97bb                 ; 
                        jsr S_2b89                  ; 
                        sta SP5Y                    ; VIC($D00B) Sprite 5 Y-Pos (Bits 0-7)
                        lsr a                       ; 
                        bcs B_2a80                  ; 
                        lda #$20                    ; 
                        ora MSIGX                   ; VIC($D010) MSB X-Pos Sprites 0-7
                        sta MSIGX                   ; VIC($D010) MSB X-Pos Sprites 0-7
                        lda #$58                    ; 
                        sta SP5X                    ; VIC($D00A) Sprite 5 X-Pos (Bits 0-7 - Bit 8 in MSIGX = $D010)
                        lda #$8b                    ; 
                        sta BH_SpritePointer05      ; 
                        lda #$28                    ; 
                        ora #$80                    ; 
J_2a6d                  sta HI_9705                 ; 
                        lda #$ff                    ; 
                        sta HI_965d                 ; 
                        lda #$01                    ; 
                        jsr HI_9037                 ; 
                        ldx #$05                    ; 
                        jsr HI_8edd                 ; 
                        rts                         ; 
; -------------------------------------------------------------------------------------------------------------- ;
B_2a80                  lda #$df                    ; 
                        and MSIGX                   ; VIC($D010) MSB X-Pos Sprites 0-7
                        sta MSIGX                   ; VIC($D010) MSB X-Pos Sprites 0-7
                        lda #$00                    ; 
                        sta SP5X                    ; VIC($D00A) Sprite 5 X-Pos (Bits 0-7 - Bit 8 in MSIGX = $D010)
                        lda #$8c                    ; 
                        sta BH_SpritePointer05      ; 
                        lda #$28                    ; 
                        jmp J_2a6d                  ; 
; -------------------------------------------------------------------------------------------------------------- ;
LO_2a97                 lda HI_97bb                 ; 
                        bne B_2a9d                  ; 
                        
B_2a9c                  rts                         ; 
                        
B_2a9d                  lda HI_9705                 ; 
                        bmi B_2ac5                  ; 
                        lda #$20                    ; 
                        bit MSIGX                   ; VIC($D010) MSB X-Pos Sprites 0-7
                        beq B_2a9c                  ; 
                        lda SP5X                    ; VIC($D00A) Sprite 5 X-Pos (Bits 0-7 - Bit 8 in MSIGX = $D010)
                        cmp #$58                    ; 
                        bcc B_2a9c                  ; 
B_2ab0                  lda #$00                    ; 
                        sta HI_979d                 ; 
                        ldx #$05                    ; 
                        jsr LO_3503                 ; 
                        lda #$ff                    ; 
                        sta HI_971d                 ; 
                        lda #$00                    ; 
                        sta HI_97bb                 ; 
                        rts                         ; 
; -------------------------------------------------------------------------------------------------------------- ;
B_2ac5                  lda #$20                    ; 
                        bit MSIGX                   ; VIC($D010) MSB X-Pos Sprites 0-7
                        bne B_2a9c                  ; 
                        lda SP5X                    ; VIC($D00A) Sprite 5 X-Pos (Bits 0-7 - Bit 8 in MSIGX = $D010)
                        cmp #$04                    ; 
                        bcc B_2ab0                  ; 
                        rts                         ; 
; -------------------------------------------------------------------------------------------------------------- ;
LO_2ad4                 lda HI_97bb                 ; 
                        bne B_2ada                  ; 
                        
                        rts                         ; 
                        
B_2ada                  lda #$20                    ; 
                        bit BH_TabSprtSprtCollReg   ; 
                        bne B_2ae2                  ; 
                        rts                         ; 
; -------------------------------------------------------------------------------------------------------------- ;
B_2ae2                  ldx #$02                    ; 
B_2ae4                  jsr LO_350f                 ; 
                        
                        bit BH_TabSprtSprtCollReg   ; 
                        bne B_2af0                  ; 
                        
B_2aec                  dex                         ; 
                        bne B_2ae4                  ; 
                        rts                         ; 
; -------------------------------------------------------------------------------------------------------------- ;
B_2af0                  lda GR_bed0,x               ; 
                        cmp #$10                    ; 
                        bcc B_2aec                  ; 
                        jsr SetYrToXrMult2          ; 
                        lda SP0Y,y                  ; VIC($D001) Sprite 0 Y-Pos (Bits 0-7)
                        sec                         ; 
                        sbc SP5Y                    ; VIC($D00B) Sprite 5 Y-Pos (Bits 0-7)
                        bcs B_2b07                  ; 
                        eor #$ff                    ; 
                        adc #$01                    ; 
B_2b07                  cmp #$0a                    ; 
                        bcs B_2aec                  ; 
                        jsr LO_3503                 ; 
                        lda #$00                    ; 
                        sta HI_9718,x               ; 
                        jsr S_2b1a                  ; 
                        jsr LO_3784                 ; 
                        rts                         ; 
; -------------------------------------------------------------------------------------------------------------- ;
; S_2b1a                Does    : 
;                       Expects : 
;                       Returns : 
; -------------------------------------------------------------------------------------------------------------- ;
S_2b1a                  subroutine                  ; 
                        lda #$00                    ; 
                        sta HI_979d                 ; 
                        lda #$20                    ; 
                        ora SPMC                    ; VIC($D01C) Sprite Multicolor
                        sta SPMC                    ; VIC($D01C) Sprite Multicolor
                        lda #$08                    ; 
                        sta SPMC0                   ; VIC($D025) Sprite Multicolor Register 0
                        lda #$00                    ; 
                        sta SPMC1                   ; VIC($D026) Sprite Multicolor Register 1
                        lda #$07                    ; 
                        sta SP5COL                  ; VIC($D02C) Color Sprite 5
                        lda #$88                    ; 
                        sta BH_SpritePointer05      ; 
                        lda #$14                    ; 
                        jsr HI_8ffd                 ; 
                        lda #$01                    ; 
                        sta HI_97bc                 ; 
                        jsr S_2387                  ; 
                        rts                         ; 
; -------------------------------------------------------------------------------------------------------------- ;
LO_2b49                 lda HI_97bc                 ; 
                        bne B_2b4f                  ; 
B_2b4e                  rts                         ; 
; -------------------------------------------------------------------------------------------------------------- ;
B_2b4f                  lda HI_96c2                 ; 
                        bne B_2b4e                  ; 
                        ldx #$05                    ; 
                        jsr LO_3503                 ; 
                        lda #$df                    ; 
                        and SPMC                    ; VIC($D01C) Sprite Multicolor
                        sta SPMC                    ; VIC($D01C) Sprite Multicolor
                        lda #$00                    ; 
                        sta SP5COL                  ; VIC($D02C) Color Sprite 5
                        lda #$00                    ; 
                        sta HI_97bb                 ; 
                        sta HI_97bc                 ; 
                        lda #$ff                    ; 
                        sta HI_971d                 ; 
                        rts                         ; 
; -------------------------------------------------------------------------------------------------------------- ;
; LO_2b74               Does    : 
;                       Expects : 
;                       Returns : 
; -------------------------------------------------------------------------------------------------------------- ;
LO_2b74                 subroutine                  ; 
                        lda #$01                    ; 
                        sta CIACRB                  ; CIA1($DC0F) Control Register B
                        
                        lda RASTER                  ; VIC($D012) Read : Current Raster Scan Line (Bit 8 in SCROLY = $D011)
                        eor TIMBLO                  ; CIA1($DC06) Timer B (low byte)
                        eor TIMBHI                  ; CIA1($DC07) Timer B (high byte)
                        adc HI_97bd                 ; 
                        sta HI_97bd                 ; 
                        
                        rts                         ; 
; -------------------------------------------------------------------------------------------------------------- ;
; S_2b89                Does    : 
;                       Expects : 
;                       Returns : 
; -------------------------------------------------------------------------------------------------------------- ;
S_2b89                  subroutine                  ; 
                        jsr LO_2b74                 ; 
J_2b8c                  cmp #$4a                    ; 
                        bcs B_2b93                  ; 
                        adc #$4a                    ; 
                        rts                         ; 
; -------------------------------------------------------------------------------------------------------------- ;
B_2b93                  adc #$20                    ; 
                        jmp J_2b8c                  ; 
; -------------------------------------------------------------------------------------------------------------- ;
; S_2b98                Does    : 
;                       Expects : 
;                       Returns : 
; -------------------------------------------------------------------------------------------------------------- ;
S_2b98                  subroutine                  ; 
                        jsr LO_2b74                 ; 
                        cmp #$28                    ; 
                        bcs B_2ba1                  ; 
                        adc #$38                    ; 
B_2ba1                  rts                         ; 
; -------------------------------------------------------------------------------------------------------------- ;
ScreenReadyPrepareMap   jsr ScreenStatusGetReady    ; display 'get ready' screen
                        
                        ldx #<BH_ScreenDataBayMap   ; 
LO_2ba8                 equ * + $02                 ; .hbu. - obsolete
                        ldy #>BH_ScreenDataBayMap   ; 
ScreenReadyPrepareMapX  rts                         ; 
; -------------------------------------------------------------------------------------------------------------- ;
                        lda BH_TabNumberOfPlayers   ; 
                        cmp #$02                    ; 
                        bne B_2bb6                  ; 
                        
                        ldx #$00                    ; 
                        jmp J_2bbf                  ; 
                        
B_2bb6                  ldx #$00                    ; 
                        lda HI_9602                 ; 
                        bne J_2bbf                  ; 
                        
                        ldx #$01                    ; player 2
LO_2bc0                 equ * + $01                 ; .hbu. - obsolete
J_2bbf                  stx BH_TabActualPlayerNumber; 
                        jsr PlayerValuesRestore     ; 
                        jsr ScreenStatusGetReady    ; display 'get ready' screen
                        
LO_2bca                 equ * + $02                 ; .hbu. - obsolete
                        lda BH_TabNumberOfPlayers   ; 
                        cmp #$02                    ; 
                        bne B_2bd6                  ; 
                        
                        ldx #OffTextStatusPlayerTwo ; 
                        ldy #$15 ; 
                        jsr ScreenStatusTextOutRow4 ; xr=input text offset  yr=output text offset
                        
B_2bd6                  lda #$02                    ; 
                        sta HI_9617                 ; 
                        jsr S_33f9                  ; 
                        
                        rts                         ; 
; -------------------------------------------------------------------------------------------------------------- ;
; LO_2bdf               Does    : 
;                       Expects : 
;                       Returns : 
; -------------------------------------------------------------------------------------------------------------- ;
LO_2bdf                 subroutine                  ; 
                        ldx BH_TabActualPlayerNumber; 
                        jsr PlayerValuesSave        ; 
                        
                        lda BH_TabNumberOfPlayers   ; 
                        cmp #$02                    ; 
                        beq B_2bef                  ; 
                        
J_2bec                  jmp J_2c86                  ; 
                        
B_2bef                  jmp J_2c39                  ; 
; -------------------------------------------------------------------------------------------------------------- ;
                        nop                         ; 
; -------------------------------------------------------------------------------------------------------------- ;
J_2bf3                  ldx #$01                    ; player 2
                        stx BH_TabActualPlayerNumber; 
                        jsr PlayerValuesRestore     ; 
                        
                        lda #$01                    ; 
                        rts                         ; 
; -------------------------------------------------------------------------------------------------------------- ;
LO_2bfe                 jsr HI_9582                 ; SpritesReset
                        
                        lda #$00                    ; 
                        jsr HI_8d82                 ; 
                        jsr S_2c7d                  ; 
                        beq B_2c10                  ; 
                        
                        pla                         ; 
                        pla                         ; 
                        jmp BH_ChapCaveCrossings    ; 
                        
B_2c10                  pla                         ; 
                        pla                         ; 
                        jmp HI_6a0a                 ; 
; -------------------------------------------------------------------------------------------------------------- ;
LO_2c15                 sta HI_9608                 ; 
                        
                        ldx BH_TabActualPlayerNumber; 
                        sta HI_9602,x               ; 
                        
                        jsr LO_2bdf                 ; 
                        beq B_2c2e                  ; 
                        
                        dec BH_TabNumberOfPlayers   ; 
                        pla                         ; 
                        pla                         ; 
                        jsr HI_6be3                 ; 
                        jmp BH_ChapCaveCrossings    ; 
                        
B_2c2e                  dec BH_TabNumberOfPlayers   ; 
                        beq B_2c36                  ; 
                        
                        jmp B_2c10                  ; 
                        
B_2c36                  jmp HI_6f53                 ; 
; -------------------------------------------------------------------------------------------------------------- ;
J_2c39                  cpx #$01                    ; 
                        bne B_2c48                  ; 
                        
                        ldx #$00                    ; player 1
                        stx BH_TabActualPlayerNumber; 
                        nop                         ; 
                        nop                         ; 
                        nop                         ; 
                        jmp J_2bec                  ; 
                        
B_2c48                  jmp J_2bf3                  ; 
; -------------------------------------------------------------------------------------------------------------- ;
LO_2c4b                 jsr LO_2bdf                 ; 
                        beq B_2c53                  ; 
                        
                        jmp BH_ChapPlaneShootout    ; 
                        
B_2c53                  jmp BH_ChapShipShootout     ; 
; -------------------------------------------------------------------------------------------------------------- ;
LO_2c56                 sta HI_9608                 ; 
                        
                        ldx BH_TabActualPlayerNumber; 
                        sta HI_9602,x               ; 
                        jsr LO_2bdf                 ; 
                        beq B_2c72                  ; 
                        
                        dec BH_TabNumberOfPlayers   ; 
                        pla                         ; 
                        pla                         ; 
                        jsr HI_6be3                 ; 
                        jsr HI_7500                 ; 
                        jmp BH_ChapPlaneShootout    ; 
                        
B_2c72                  dec BH_TabNumberOfPlayers   ; 
                        beq B_2c7a                  ; 
                        
                        jmp J_2cf1                  ; 
                        
B_2c7a                  jmp HI_7458                 ; 
; -------------------------------------------------------------------------------------------------------------- ;
; S_2c7d                Does    : 
;                       Expects : 
;                       Returns : 
; -------------------------------------------------------------------------------------------------------------- ;
S_2c7d                  subroutine                  ; 
                        lda #$01                    ; 
                        sta HI_9609                 ; 
                        
                        jsr LO_2bdf                 ; 
                        
                        rts                         ; 
; -------------------------------------------------------------------------------------------------------------- ;
J_2c86                  ldx BH_TabActualPlayerNumber; 
                        jsr PlayerValuesRestore     ; 
                        
                        lda #$00                    ; 
                        rts                         ; 
; -------------------------------------------------------------------------------------------------------------- ;
LO_2c8f                 jsr S_2407                  ; 
                        beq B_2c97                  ; 
                        jmp BH_ChapShipShootout     ; 
                        
B_2c97                  jmp HI_6b0a                 ; 
; -------------------------------------------------------------------------------------------------------------- ;
LO_2c9a                 jsr LO_39b6                 ; 
                        lda #$00                    ; 
                        sta HI_9608                 ; 
                        ldx BH_TabActualPlayerNumber; 
                        sta HI_9602,x               ; 
                        
                        jsr LO_2bdf                 ; 
                        beq B_2cbe                  ; 
                        dec BH_TabNumberOfPlayers   ; 
                        pla                         ; 
                        pla                         ; 
                        jsr HI_6be3                 ; 
                        jsr HI_7500                 ; 
                        jsr HI_80e9                 ; 
                        jmp BH_ChapShipShootout     ; 
                        
B_2cbe                  dec BH_TabNumberOfPlayers   ; 
                        beq B_2cc6                  ; 
                        jmp J_2cec                  ; 
B_2cc6                  pla                         ; 
                        pla                         ; 
                        pla                         ; 
                        pla                         ; 
                        rts                         ; 
; -------------------------------------------------------------------------------------------------------------- ;
LO_2ccb                 sta HI_9608                 ; 
                        ldx BH_TabActualPlayerNumber; 
                        lda #$00                    ; 
                        sta HI_9602,x               ; 
                        jsr LO_2bdf                 ; 
                        dec BH_TabNumberOfPlayers   ; 
                        beq B_2ce9                  ; 
                        pla                         ; 
                        pla                         ; 
                        jsr HI_6be3                 ; 
                        jsr HI_8688                 ; ScreenStatusTank
                        jmp HI_811a                 ; ChapTanksOnBeach
; -------------------------------------------------------------------------------------------------------------- ;
B_2ce9                  jmp HI_853a                 ; 
J_2cec                  pla                         ; 
                        pla                         ; 
                        jmp HI_6b0a                 ; 
J_2cf1                  pla                         ; 
                        pla                         ; 
                        jmp BH_ChapShipShootout     ; 
; -------------------------------------------------------------------------------------------------------------- ;
; ScreenStatusInitLevel Does    : 
;                       Expects : 
;                       Returns : 
; -------------------------------------------------------------------------------------------------------------- ;
ScreenStatusInitLevel   subroutine                  ; 
                        jsr ScreenStatusTextOutRow1 ; xr=input text offset  yr=output text offset (Level)
                        
                        lda BH_TabSkillLevel        ; 
                        jsr MakeDigit               ; xr=right nibble yr=left nibble
                        sty BH_Scrn_Status + $032b  ; 
                        
                        lda #WHITE                  ; 
                        sta COLORAM + $032b         ; 
                        
ScreenStatusInitLevelX  rts                         ; 
; -------------------------------------------------------------------------------------------------------------- ;
; S_2d08                Does    : 
;                       Expects : 
;                       Returns : 
; -------------------------------------------------------------------------------------------------------------- ;
S_2d08                  subroutine                  ; 
                        jsr ScreenStatusTextOutRow2 ; xr=input text offset  yr=output text offset (Player)
                        
                        ldx BH_TabActualPlayerNumber; 
                        inx                         ; 
                        txa                         ; 
                        jsr MakeDigit               ; xr=right nibble yr=left nibble
                        sty BH_Scrn_Status + $0353  ; 
                        
                        lda #YELLOW                 ; 
                        sta COLORAM + $0353         ; 
                        
                        rts                         ; 
; -------------------------------------------------------------------------------------------------------------- ;
LO_2d1c                 lda #$02                    ; 
                        bit MSIGX                   ; VIC($D010) MSB X-Pos Sprites 0-7
                        bne B_2d29                  ; 
                        
                        lda SP5X                    ; VIC($D00A) Sprite 5 X-Pos (Bits 0-7 - Bit 8 in MSIGX = $D010)
                        jmp HI_7bbc                 ; 
                        
B_2d29                  jmp HI_7bfb                 ; 
; -------------------------------------------------------------------------------------------------------------- ;
LO_2d2c                 jsr LO_39df                 ; 
                        jsr HI_7471                 ; 
                        
                        jmp HI_70f3                 ; 
; -------------------------------------------------------------------------------------------------------------- ;
LO_2d35                 jsr HI_9260                 ; 
                        jsr LO_39df                 ; 
                        jsr HI_8094                 ; 
                        
                        jmp HI_794a                 ; 
; -------------------------------------------------------------------------------------------------------------- ;
LO_2d41                 jsr LO_39df                 ; 
                        jsr HI_863e                 ; 
                        jsr HI_936c                 ; 
                        
                        jmp BH_ChapTanksOnBeachBackL; 
; -------------------------------------------------------------------------------------------------------------- ;
LO_2d4d                 lda HI_961b                 ; 
                        clc                         ; 
                        adc #$04                    ; 
                        
                        rts                         ; 
; -------------------------------------------------------------------------------------------------------------- ;
S_2d54                  jsr ScreenStatusTextOutRow3 ; xr=input text offset  yr=output text offset
                        
                        lda BH_TabGameMode          ; 
                        bne B_2d5f                  ; BH_TabGameModeDemo/BH_TabGameModeExit
                        
                        jmp J_3862                  ; 
                        
B_2d5f                  jmp J_3864                  ; 
; -------------------------------------------------------------------------------------------------------------- ;
LO_2d62                 lda HI_9609                 ; 
                        and #$01                    ; 
                        rts                         ; 
; -------------------------------------------------------------------------------------------------------------- ;
; SkillLevelInit        Does    : 
;                       Expects : 
;                       Returns : 
; -------------------------------------------------------------------------------------------------------------- ;
SkillLevelInit          subroutine                  ; 
                        ldx BH_TabSkillLevel        ; 
                        dex                         ; 
                        lda GR_bed8,x               ; 
                        sta HI_6cca                 ; 
                        
                        lda GR_bef4,x               ; 
                        sta HI_6ccf                 ; 
                        
                        lda GR_bedc,x               ; 
                        sta HI_6cd4                 ; 
                        
                        lda GR_bef8,x               ; 
                        sta HI_6cd9                 ; 
                        
                        lda GR_bee0,x               ; 
                        sta HI_6cde                 ; 
                        
                        lda GR_befc,x               ; 
                        sta HI_6ce3                 ; 
                        
                        lda GR_bee4,x               ; 
                        sta HI_6ce8                 ; 
                        
                        lda GR_bee8,x               ; 
                        sta HI_6ced                 ; 
                        
                        lda GR_beec,x               ; 
                        sta HI_6cf2                 ; 
                        
                        lda GR_bef0,x               ; 
                        sta HI_6cf7                 ; 
                        
                        lda GR_bf00,x               ; 
                        sta U_3a6a                  ; 
                        
                        lda GR_bf04,x               ; 
                        sta HI_70a1                 ; 
                        
                        sec                         ; 
                        sbc #$14                    ; 
                        sta HI_709c                 ; 
                        
                        lda GR_bf08,x               ; 
                        sta HI_7441                 ; 
                        
                        lda GR_bf0c,x               ; 
                        sta HI_7b06                 ; 
                        
                        lda GR_bf10,x               ; 
                        sta U_3947                  ; 
                        
                        lda GR_bf14,x               ; 
                        sta HI_83f3                 ; 
                        
                        lda GR_bf18,x               ; 
                        sta HI_94c1                 ; 
                        
                        rts                         ; 
; -------------------------------------------------------------------------------------------------------------- ;
; S_2dd9                Does    : 
;                       Expects : 
;                       Returns : 
; -------------------------------------------------------------------------------------------------------------- ;
S_2dd9                  subroutine                  ; 
                        jsr HI_95b2                 ; 
                        jsr ScreenStatusShowScore   ; 
                        
                        ldx #$06                    ; 
B_2de1                  lda BH_Scrn_Status + $0377,x; 
                        sta BH_Scrn_Status + $035c,x; 
                        
                        lda #BLACK                  ; 
                        sta COLORAM + $0377,x       ; 
                        
                        lda #WHITE                  ; 
                        sta COLORAM + $035c,x       ; 
                        
                        dex                         ; 
                        bne B_2de1                  ; 
                        
                        ldy #$0e                    ; 
                        ldx #OffTextStatusScore     ; 
                        lda #WHITE                  ; 
                        sta BH_TabScrnStatusTextColor ; 
                        
                        rts                         ; 
; -------------------------------------------------------------------------------------------------------------- ;
                        nop                         ; 
                        nop                         ; 
; -------------------------------------------------------------------------------------------------------------- ;
; IRQ_DemoMoveSprites   Does    : 
;                       Expects : 
;                       Returns : 
; -------------------------------------------------------------------------------------------------------------- ;
IRQ_DemoMoveSprites     subroutine                  ; 
                        ldx #$07                    ; 
B_2e02                  lda HI_9798,x               ; 
                        bne B_2e0b                  ; 
                        
J_2e07                  dex                         ; 
                        bpl B_2e02                  ; 
                        
                        rts                         ; 
                        
B_2e0b                  jsr IRQ_S_2ee0              ; 
                        beq B_2e51                  ; 
                        
                        jsr IRQ_S_2f00              ; 
                        
                        clc                         ; 
                        adc HI_97a0,x               ; 
                        sta HI_97a0,x               ; 
                        
                        sec                         ; 
                        sbc #$3c                    ; 
                        bcc B_2e25                  ; 
                        
                        sta HI_97a0,x               ; 
                        
                        inc HI_97b8                 ; 
B_2e25                  jsr SetYrToXrMult2          ; yr = xr * 2
                        lda HI_9700,x               ; 
                        bmi B_2e45                  ; 
                        
                        lda SP0X,y                  ; VIC($D000) Sprite 0 X-Pos (Bits 0-7 - Bit 8 in MSIGX = $D010)
                        clc                         ; 
                        adc HI_97b8                 ; 
                        sta SP0X,y                  ; VIC($D000) Sprite 0 X-Pos (Bits 0-7 - Bit 8 in MSIGX = $D010)
                        bcc B_2e51                  ; 
                        
B_2e39                  jsr LO_350f                 ; 
                        
                        eor MSIGX                   ; VIC($D010) MSB X-Pos Sprites 0-7
                        sta MSIGX                   ; VIC($D010) MSB X-Pos Sprites 0-7
                        jmp B_2e51                  ; 
                        
B_2e45                  lda SP0X,y                  ; VIC($D000) Sprite 0 X-Pos (Bits 0-7 - Bit 8 in MSIGX = $D010)
                        sec                         ; 
                        sbc HI_97b8                 ; 
                        sta SP0X,y                  ; VIC($D000) Sprite 0 X-Pos (Bits 0-7 - Bit 8 in MSIGX = $D010)
                        bcc B_2e39                  ; 
                        
B_2e51                  jsr S_2ee8                  ; 
                        beq B_2e8a                  ; 
                        
                        jsr IRQ_S_2f00              ; 
                        
                        clc                         ; 
                        adc HI_97a8,x               ; 
                        sta HI_97a8,x               ; 
                        
                        sec                         ; 
                        sbc #$3c                    ; 
                        bcc B_2e6b                  ; 
                        
                        sta HI_97a8,x               ; 
                        
                        inc HI_97b8                 ; 
B_2e6b                  jsr SetYrToXrMult2          ; yr = xr * 2
                        lda HI_9708,x               ; 
                        bmi B_2e80                  ; 
                        
                        lda SP0Y,y                  ; VIC($D001) Sprite 0 Y-Pos (Bits 0-7)
                        sec                         ; 
                        jsr HI_8cdd                 ; 
                        
                        sta SP0Y,y                  ; VIC($D001) Sprite 0 Y-Pos (Bits 0-7)
                        jmp B_2e8a                  ; 
                        
B_2e80                  lda SP0Y,y                  ; VIC($D001) Sprite 0 Y-Pos (Bits 0-7)
                        clc                         ; 
                        jsr HI_8cd3                 ; 
                        
                        sta SP0Y,y                  ; VIC($D001) Sprite 0 Y-Pos (Bits 0-7)
B_2e8a                  jsr S_2ef0                  ; 
                        beq B_2ec0                  ; 
                        
                        jsr IRQ_S_2f00              ; 
                        
                        clc                         ; 
                        adc HI_97b0,x               ; 
                        sta HI_97b0,x               ; 
                        
                        sec                         ; 
                        sbc #$3c                    ; 
                        bcc B_2ea4                  ; 
                        
                        sta HI_97b0,x               ; 
                        
                        inc HI_97b8                 ; 
                        
B_2ea4                  lda HI_9710,x               ; 
                        bpl B_2eb6                  ; 
                        
                        lda GR_bed0,x               ; 
                        sec                         ; 
                        sbc HI_97b8                 ; 
                        sta GR_bed0,x               ; 
                        
                        jmp B_2ec0                  ; 
                        
B_2eb6                  lda GR_bed0,x               ; 
                        clc                         ; 
                        adc HI_97b8                 ; 
                        sta GR_bed0,x               ; 
                        
B_2ec0                  jmp J_2e07                  ; 
                        
                        ldy #$00                    ; 
                        sec                         ; 
                        sbc #$3c                    ; 
                        bcc B_2ecc                  ; 
                        
                        ldy #$01                    ; 
B_2ecc                  sty HI_97b8                 ; 

IRQ_DemoMoveSpritesX    rts                         ; 
; -------------------------------------------------------------------------------------------------------------- ;
; IRQ_S_2ed0            Does    : 
;                       Expects : 
;                       Returns : 
; -------------------------------------------------------------------------------------------------------------- ;
IRQ_S_2ed0              subroutine                  ; 
                        jsr IRQ_S_314c              ; 
                        jsr IRQ_DemoMoveSprites     ; but not map tank and hill
                        
                        rts                         ; 
; -------------------------------------------------------------------------------------------------------------- ;
A_2ed7                  dc.b $77 ; .hbu.
                        dc.b $00 ; 
                        dc.b $7f ; 
                        dc.b $00 ; 
                        dc.b $88 ; 
                        dc.b $04 ; 
                        dc.b $7f ; 
                        dc.b $00 ; 
                        dc.b $79 ; 
; -------------------------------------------------------------------------------------------------------------- ;
; IRQ_S_2ee0            Does    : 
;                       Expects : 
;                       Returns : 
; -------------------------------------------------------------------------------------------------------------- ;
IRQ_S_2ee0              subroutine                  ; 
                        lda HI_9700,x               ; 
                        and #$7f                    ; .#######
                        
                        rts                         ; 
; -------------------------------------------------------------------------------------------------------------- ;
A_2ee6                  dc.b $00 ; 
                        dc.b $7f ; 
; -------------------------------------------------------------------------------------------------------------- ;
; S_2ee8                Does    : 
;                       Expects : 
;                       Returns : 
; -------------------------------------------------------------------------------------------------------------- ;
S_2ee8                  subroutine                  ; 
                        lda HI_9708,x               ; 
                        and #$7f                    ; 
                        rts                         ; 
; -------------------------------------------------------------------------------------------------------------- ;
                        php                         ; 
                        iny                         ; 
; -------------------------------------------------------------------------------------------------------------- ;
; S_2ef0                Does    : 
;                       Expects : 
;                       Returns : 
; -------------------------------------------------------------------------------------------------------------- ;
S_2ef0                  subroutine                  ; 
                        lda HI_9710,x               ; 
                        and #$7f                    ; 
                        rts                         ; 
; -------------------------------------------------------------------------------------------------------------- ;
                        brk                         ; 
                        adc HI_8009,y               ; 
                        sta HI_9700                 ; 
                        rts                         ; 
; -------------------------------------------------------------------------------------------------------------- ;
A_2efe                  dc.b $f9 ; 
                        dc.b $08 ; 
; -------------------------------------------------------------------------------------------------------------- ;
; IRQ_S_2f00            Does    : 
;                       Expects : 
;                       Returns : 
; -------------------------------------------------------------------------------------------------------------- ;
IRQ_S_2f00              subroutine                  ; 
                        ldy #$00                    ; 
                        sec                         ; 
                        sbc #$3c                    ; 
                        bcc B_2f0d                  ; 
                        
                        ldy #$01                    ; 
                        sty HI_97b8                 ; 
                        
                        rts                         ; 
                        
B_2f0d                  nop                         ; 
                        nop                         ; 
                        
                        clc                         ; 
                        adc #$3c                    ; 
                        sty HI_97b8                 ; 
                        
                        rts                         ; 
; -------------------------------------------------------------------------------------------------------------- ;
A_2f16                  dc.b $00 ; .hbu.
                        dc.b $5c ; 
                        dc.b $00 ; 
                        dc.b $7f ; 
                        dc.b $00 ; 
                        dc.b $3f ; 
                        dc.b $48 ; h
                        dc.b $7f ; 
                        dc.b $01 ; 
                        dc.b $7d ; 
A_2f20                  dc.b $20 ; 
                        dc.b $7f ; 
                        dc.b $00 ; 
                        dc.b $7f ; 
                        dc.b $01 ; 
                        dc.b $7f ; 
                        dc.b $00 ; 
                        dc.b $7f ; 
                        dc.b $00 ; 
                        dc.b $7f ; 
                        dc.b $00 ; 
                        dc.b $7f ; 
                        dc.b $00 ; 
                        dc.b $7f ; 
                        dc.b $00 ; 
                        dc.b $7d ; 
A_2f30                  dc.b $15 ; 
                        dc.b $7f ; 
                        dc.b $00 ; 
                        dc.b $7f ; 
                        dc.b $00 ; 
                        dc.b $7f ; 
                        dc.b $00 ; 
                        dc.b $7f ; 
                        dc.b $00 ; 
                        dc.b $7f ; 
                        dc.b $00 ; 
                        dc.b $7f ; 
                        dc.b $00 ; 
                        dc.b $7f ; 
                        dc.b $00 ; 
                        dc.b $0c ; 
A_2f40                  dc.b $80 ; 
                        dc.b $ff ; 
                        dc.b $80 ; 
                        dc.b $ff ; 
                        dc.b $80 ; 
                        dc.b $ff ; 
                        dc.b $80 ; 
                        dc.b $ff ; 
                        dc.b $80 ; 
                        dc.b $ff ; 
                        dc.b $00 ; 
                        dc.b $cc ; L
                        dc.b $80 ; 
                        dc.b $ff ; 
                        dc.b $80 ; 
                        dc.b $89 ; 
A_2f50                  dc.b $80 ; 
                        dc.b $ff ; 
                        dc.b $80 ; 
                        dc.b $ff ; 
                        dc.b $80 ; 
                        dc.b $ff ; 
                        dc.b $80 ; 
                        dc.b $ff ; 
                        dc.b $80 ; 
                        dc.b $ff ; 
                        dc.b $80 ; 
                        dc.b $7f ; 
                        dc.b $80 ; 
                        dc.b $ff ; 
                        dc.b $80 ; 
                        dc.b $ff ; 
A_2f60                  dc.b $80 ; 
                        dc.b $ff ; 
                        dc.b $00 ; 
                        dc.b $ff ; 
                        dc.b $80 ; 
                        dc.b $ff ; 
                        dc.b $80 ; 
                        dc.b $81 ; 
                        dc.b $80 ; 
                        dc.b $ff ; 
                        dc.b $00 ; 
                        dc.b $7d ; 
                        dc.b $80 ; 
                        dc.b $ff ; 
                        dc.b $80 ; 
                        dc.b $7d ; 
A_2f70                  dc.b $80 ; 
                        dc.b $ff ; 
                        dc.b $80 ; 
                        dc.b $fd ; 
                        dc.b $80 ; 
                        dc.b $ff ; 
                        dc.b $80 ; 
                        dc.b $f8 ; 
                        dc.b $80 ; 
                        dc.b $ff ; 
                        dc.b $80 ; 
                        dc.b $ff ; 
                        dc.b $f5 ; 
                        dc.b $ff ; 
                        dc.b $04 ; 
                        dc.b $7f ; 
A_2f80                  dc.b $90 ; 
                        dc.b $ff ; 
                        dc.b $f7 ; 
                        dc.b $98 ; 
                        dc.b $80 ; 
                        dc.b $ff ; 
                        dc.b $80 ; 
                        dc.b $7f ; 
                        dc.b $80 ; 
                        dc.b $ff ; 
                        dc.b $80 ; 
                        dc.b $ff ; 
                        dc.b $80 ; 
                        dc.b $ff ; 
                        dc.b $80 ; 
                        dc.b $ff ; 
A_2f90                  dc.b $f5 ; 
                        dc.b $ff ; 
                        dc.b $80 ; 
                        dc.b $ff ; 
                        dc.b $80 ; 
                        dc.b $ff ; 
                        dc.b $80 ; 
                        dc.b $ff ; 
                        dc.b $f5 ; 
                        dc.b $ff ; 
                        dc.b $80 ; 
                        dc.b $ff ; 
                        dc.b $80 ; 
                        dc.b $ff ; 
                        dc.b $81 ; 
                        dc.b $88 ; 
A_2fa0                  dc.b $80 ; 
                        dc.b $ff ; 
                        dc.b $80 ; 
                        dc.b $ef ; 
                        dc.b $01 ; 
                        dc.b $ff ; 
                        dc.b $80 ; 
                        dc.b $ff ; 
                        dc.b $88 ; 
                        dc.b $8c ; 
                        dc.b $80 ; 
                        dc.b $ff ; 
                        dc.b $80 ; 
                        dc.b $ff ; 
                        dc.b $80 ; 
                        dc.b $88 ; 
A_2fb0                  dc.b $80 ; 
                        dc.b $ff ; 
                        dc.b $80 ; 
                        dc.b $ff ; 
                        dc.b $80 ; 
                        dc.b $ff ; 
                        dc.b $80 ; 
                        dc.b $ff ; 
                        dc.b $80 ; 
                        dc.b $ff ; 
                        dc.b $80 ; 
                        dc.b $fd ; 
                        dc.b $98 ; 
                        dc.b $ff ; 
                        dc.b $80 ; 
                        dc.b $ff ; 
A_2fc0                  dc.b $00 ; 
                        dc.b $7f ; 
                        dc.b $00 ; 
                        dc.b $7d ; 
                        dc.b $00 ; 
                        dc.b $7f ; 
                        dc.b $00 ; 
                        dc.b $7f ; 
                        dc.b $00 ; 
                        dc.b $7f ; 
                        dc.b $00 ; 
                        dc.b $7f ; 
                        dc.b $00 ; 
                        dc.b $7d ; 
                        dc.b $00 ; 
                        dc.b $7d ; 
A_2fd0                  dc.b $00 ; 
                        dc.b $7f ; 
                        dc.b $00 ; 
                        dc.b $7f ; 
                        dc.b $00 ; 
                        dc.b $7f ; 
                        dc.b $00 ; 
                        dc.b $77 ; W
                        dc.b $00 ; 
                        dc.b $7f ; 
                        dc.b $04 ; 
                        dc.b $88 ; 
                        dc.b $04 ; 
                        dc.b $7f ; 
                        dc.b $00 ; 
                        dc.b $79 ; Y
A_2fe0                  dc.b $00 ; 
                        dc.b $7f ; 
                        dc.b $80 ; 
                        dc.b $7d ; 
                        dc.b $00 ; 
                        dc.b $7f ; 
                        dc.b $00 ; 
                        dc.b $7f ; 
                        dc.b $00 ; 
                        dc.b $7f ; 
                        dc.b $80 ; 
                        dc.b $7f ; 
                        dc.b $00 ; 
                        dc.b $7f ; 
                        dc.b $08 ; 
                        dc.b $c8 ; H
A_2ff0                  dc.b $7d ; 
                        dc.b $7f ; 
                        dc.b $00 ; 
                        dc.b $7f ; 
                        dc.b $00 ; 
                        dc.b $7f ; 
                        dc.b $00 ; 
                        dc.b $79 ; Y
                        dc.b $00 ; 
                        dc.b $7f ; 
                        dc.b $00 ; 
                        dc.b $7d ; 
                        dc.b $7d ; 
                        dc.b $7f ; 
                        dc.b $f9 ; 
                        dc.b $8c ; 
; -------------------------------------------------------------------------------------------------------------- ;
; C64IrqScollInit       Does    : 
;                       Expects : 
;                       Returns : 
; -------------------------------------------------------------------------------------------------------------- ;
C64IrqScollInit         subroutine                  ; 
                        lda #$00                    ; 
                        sta CIACRA                  ; CIA1($DC0E) Control Register A
                        
                        lda #$7f                    ; .#######
                        sta CIAICR                  ; CIA1($DC0D) Interrupt Control
                        sta CI2ICR                  ; CIA2($DD0D) Interrupt Control Register
                        
                        lda #<IRQ                   ; 
                        sta C64_CINV_LO             ; 
                        lda #>IRQ                   ; 
                        sta C64_CINV_HI             ; 
                        
                        lda #BH_TabIRQScreenPartStatus ; 
                        sta BH_TabIRQScreenPartFlag ; 
                        
                        jsr IRQ_SetScreenGfx        ; 
                        
                        sei                         ; 
                        jsr IRQ_ScrollSoft          ; 
                        
                        lda #$01                    ; 
                        sta IRQMASK                 ; VIC($D01A) IRQ Mask Register
                        cli                         ; 
                        
C64IrqScollInitX        rts                         ; 
; -------------------------------------------------------------------------------------------------------------- ;
C64Reset                sei                         ; 
                        lda #$00                    ; 
                        sta IRQMASK                 ; VIC($D01A) IRQ Mask Register
                        
                        jsr C64ScreenChrReset       ; 
                        
                        lda #$34                    ; restore IRQ
                        sta C64_CINV_LO             ; 
                        
                        lda #$ea                    ; 
                        sta C64_CINV_HI             ; 
                        
                        ldx #$1b                    ; 
                        ldy #$41                    ; 
                        jsr SetTimerA               ; 
                        
                        cli                         ; 
C64ResetX               rts                         ; 
; -------------------------------------------------------------------------------------------------------------- ;
; SetTimerA             Does    : 
;                       Expects : 
;                       Returns : 
; -------------------------------------------------------------------------------------------------------------- ;
SetTimerA               subroutine                  ; 
                        stx TIMALO                  ; CIA1($DC04) Timer A (low byte)
                        sty TIMAHI                  ; CIA1($DC05) Timer A (high byte)
                        
                        lda #$81                    ; #......# - enable timer A interrupts
                        sta CIAICR                  ; CIA1($DC0D) Interrupt Control
                        lda CIACRA                  ; CIA1($DC0E) Control Register A
                        
                        and #$80                    ; #.......
                        ora #$11                    ; ...#...# - timer A start
                        sta CIACRA                  ; CIA1($DC0E) Control Register A
                        
SetTimerAX              rts                         ; 
; -------------------------------------------------------------------------------------------------------------- ;
; IRQ_SetScreenGfx      Does    : 
;                       Expects : 
;                       Returns : 
; -------------------------------------------------------------------------------------------------------------- ;
IRQ_SetScreenGfx        subroutine                  ; 
                        lda #$c4 + VIC_MemBank_1    ; ##...##. - $02 = $4000-$7fff
                        sta CI2PRA                  ; CIA2($DD00) Data Port A - Bits 0-1 = VIC mem bank
                        
                        lda SCROLX                  ; VIC($D016) VIC Control Register 2 (Horiz Fine Scroll)
                        ora #VIC_MCM_On             ; ...#.... - Multi Color Mode=on
                        sta SCROLX                  ; VIC($D016) VIC Control Register 2 (Horiz Fine Scroll)
                        
                        lda BH_TabVicMemControl     ; 
                        sta VMCSB                   ; VIC($D018) VIC Chip Memory Control
                        
                        lda BH_TabBackGroundColor   ; 
                        sta BGCOL0                  ; VIC($D021) Background Color 0
                        
IRQ_SetScreenGfxX       rts                         ; 
; -------------------------------------------------------------------------------------------------------------- ;
; C64ScreenChrReset     Does    : 
;                       Expects : 
;                       Returns : 
; -------------------------------------------------------------------------------------------------------------- ;
C64ScreenChrReset       subroutine                  ; 
                        lda SCROLX                  ; VIC($D016) VIC Control Register 2 (Horiz Fine Scroll)
                        and #VIC_MCM_Off            ; ###.#### - multi color mode
                        sta SCROLX                  ; VIC($D016) VIC Control Register 2 (Horiz Fine Scroll)
                        
                        lda #[VIC_Video_0400 + VIC_CharS_1000 + VIC_CharS_unus] ; scrn=$0400-$07e7 chr=$1000-$17ff
                        sta VMCSB                   ; VIC($D018) VIC Chip Memory Control
                        
                        lda #$c4 + VIC_MemBank_0    ; ##...### - $03 = $0000-$3fff
                        sta CI2PRA                  ; CIA2($DD00) Data Port A - Bits 0-1 = VIC mem bank
                        
                        lda HI_962f                 ; 
                        sta BGCOL0                  ; VIC($D021) Background Color 0
                        
C64ScreenChrResetX      rts                         ; 
; -------------------------------------------------------------------------------------------------------------- ;
; IRQ_ScrollSoft        Does    : 
;                       Expects : 
;                       Returns : 
; -------------------------------------------------------------------------------------------------------------- ;
IRQ_ScrollSoft          subroutine                  ; 
                        lda SCROLY                  ; VIC($D011) VIC Control Register 1 (Vert Fine Scroll)
                        and #[VIC_SoftY_Clear & VIC_RasterHi_Off] ; $78 - .####... (isolate soft scroll bits)
                        ora BH_TabVicScrollSoftPosY ; 
                        sta SCROLY                  ; VIC($D011) VIC Control Register 1 (Vert Fine Scroll)
                        
.StatusScreenStart      lda #$cd                    ; 
                        sta RASTER                  ; VIC($D012) Read : Current Raster Scan Line (Bit 8 in SCROLY = $D011)
                        
                        lda SCROLX                  ; VIC($D016) VIC Control Register 2 (Horiz Fine Scroll)
                        and #VIC_SoftX_Clear        ; $f8 - #####... (isolate soft scroll bits)
                        ora BH_TabVicScrollSoftPosX ; 
                        sta SCROLX                  ; VIC($D016) VIC Control Register 2 (Horiz Fine Scroll)
                        
                        lda #BH_TabScrnTankBayScrollDoneYes ; 
                        sta BH_TabScrnTankBayScrollDone ; 
                        
IRQ_ScrollSoftX         rts                         ; 
; -------------------------------------------------------------------------------------------------------------- ;
                        lda SCROLY                  ; VIC($D011) VIC Control Register 1 (Vert Fine Scroll)
                        and #[VIC_SoftY_Clear & VIC_RasterHi_Off] ; $78 - .####... (isolate soft scroll bits)
                        ora #$03                    ; ......##
                        sta SCROLY                  ; VIC($D011) VIC Control Register 1 (Vert Fine Scroll)
                        
                        lda #$ff                    ; 
                        sta RASTER                  ; VIC($D012) Read : Current Raster Scan Line (Bit 8 in SCROLY = $D011)
                        
                        lda SCROLX                  ; VIC($D016) VIC Control Register 2 (Horiz Fine Scroll)
                        and #VIC_SoftX_Clear        ; $f8 - #####... (isolate soft scroll bits)
                        ora #$00                    ; 
                        sta SCROLX                  ; VIC($D016) VIC Control Register 2 (Horiz Fine Scroll)
                        
                        rts                         ; 
; -------------------------------------------------------------------------------------------------------------- ;
IRQ                     subroutine                  ; 
                        lda #$01                    ; 
                        sta VICIRQ                  ; VIC($D019) Interrupt Flags - Latched flags cleared if set to 1
                        
                        lda BH_TabIRQScreenPartFlag ; 
                        bne IRQ_ScreenPartGfx       ; 
                        
                        ldx #$05                    ; 
.Wait                   dex                         ; 
                        bne .Wait                   ; 
                        
                        jsr IRQ_ScreenPartStatus    ; 
                        
                        lda #BH_TabIRQScreenPartGfx ; 
                        sta BH_TabIRQScreenPartFlag ; 
                        
                        cli                         ; 
                        jmp IRQ_J_310d              ; 
; -------------------------------------------------------------------------------------------------------------- ;
; IRQ_ScreenTankColors  Does    : 
;                       Expects : 
;                       Returns : 
; -------------------------------------------------------------------------------------------------------------- ;
IRQ_ScreenTankColors    subroutine                  ; 
                        cli                         ; 
                        nop                         ; 
                        
                        ldx #$04                    ; 
                        ldy #$e0                    ; 
.__GetColorHi           equ * + $02                 ; 
.GetColor               lda Tab_Scrn_Gfx_Sav - $e0,y; 
.__SetColorHi           equ * + $02                 ; 
                        sta COLORAM - $e0,y         ; 
                        iny                         ; 
                        bne .GetColor               ; 
                        
                        inc .__GetColorHi           ; 
                        inc .__SetColorHi           ; 
                        
                        dex                         ; 
                        bne .GetColor               ; 
                        
                        lda #>[Tab_Scrn_Gfx_Sav - $e0] ; 
                        sta .__GetColorHi           ; 
                        lda #>[COLORAM - $e0]       ; 
                        sta .__SetColorHi           ; 
                        
                        lda #BH_TabScreenTankColorNo; 
                        sta BH_TabScreenTankColorFlag ; 
                        
IRQ_ScreenTankColorsX   rts                         ; 
; -------------------------------------------------------------------------------------------------------------- ;
IRQ_J_310d              jsr IRQ_S_2ed0              ; 
                        jsr IRQ_CheckJoystick       ; 
                        
IRQ_Return              pla                         ; 
                        tay                         ; 
                        pla                         ; 
                        tax                         ; 
                        pla                         ; 
                        rti                         ; 
; -------------------------------------------------------------------------------------------------------------- ;
IRQ_ScreenPartGfx       jsr IRQ_SetScreenGfx        ; 
                        jsr IRQ_ScrollSoft          ; 
                        
                        lda #BH_TabIRQScreenPartStatus ; 
                        sta BH_TabIRQScreenPartFlag ; 
                        
                        lda BH_TabScreenTankColorFlag ; 
                        beq B_312c                  ; BH_TabScreenTankColorNo
                        
                        jsr IRQ_ScreenTankColors    ; 
B_312c                  nop                         ; 
                        nop                         ; 
                        nop                         ; 
IRQ_ScreenPartGfxX      jmp IRQ_Return              ; 
; -------------------------------------------------------------------------------------------------------------- ;
; IRQ_CheckJoystick     Does    : 
;                       Expects : 
;                       Returns : 
; -------------------------------------------------------------------------------------------------------------- ;
IRQ_CheckJoystick       subroutine                  ; 
                        lda CIAPRA                  ; Data Port Register A
                        eor #$ff                    ; flip joystick action - $00 if set to $01
                        and #$1f                    ; ...##### - mask out joystick action
                        beq IRQ_CheckJoystickX      ; was none
                        
                        ora BH_TabJoysticAction     ; 
                        sta BH_TabJoysticAction     ; 
                        
                        lda #BH_TabGameModeGame     ; game - switch off demo
                        sta BH_TabGameMode          ; 
                        
                        lda #BH_TabUserActionYes    ; 
                        sta BH_TabUserAction        ; 
                        
IRQ_CheckJoystickX      rts                         ; 
; -------------------------------------------------------------------------------------------------------------- ;
; IRQ_S_314c            Does    : 
;                       Expects : 
;                       Returns : 
; -------------------------------------------------------------------------------------------------------------- ;
IRQ_S_314c              subroutine                  ; 
                        ldy #$28                    ; 
                        ldx #$00                    ; 
B_3150                  lda HI_96b0,x               ; 
                        beq B_3165                  ; 
                        
                        dec HI_9688,x               ; 
                        bne B_3165                  ; 
                        
                        lda #$00                    ; 
                        sta HI_96b0,x               ; 
                        
                        lda HI_96d8,x               ; 
                        sta HI_9688,x               ; 
                        
B_3165                  inx                         ; 
                        dey                         ; 
                        bne B_3150                  ; 
                        
                        rts                         ; 
; -------------------------------------------------------------------------------------------------------------- ;
; TankScrollTerrain     Does    : Scroll tank screen
;                       Expects : 
;                       Returns : 
; -------------------------------------------------------------------------------------------------------------- ;
TankScrollTerrain       subroutine                  ; 
                        lda BH_TabScrnTankBayScrollDone ; 
                        bne TankScrollTerrainX      ; BH_TabScrnTankBayScrollDoneNo
                        
                        lda HI_96b0                 ; 
                        bne TankScrollTerrainX      ; 
                        
                        lda #$01                    ; 
                        sta HI_96b0                 ; 
                        
                        jsr TankScrollStrandSoft    ; 
                        
                        ldy #$07                    ; 
                        cpy BH_TabTankScrollSoftPosX; 
                        bcs .SetVicScrollX          ; greater/equal
                        
                        jsr TankScrollStrandHard    ; 
                        
                        dec BH_TabScrnTankBayScrollPos ; 
                        dec HI_963e                 ; 
                        dec BH_TabScrnTankBayCharNext ; 
                        bpl .NextScrollPosX         ; 
                        
                        ldx #BH_TabScrnTankBayCharNextIni ; 
                        stx BH_TabScrnTankBayCharNext ; 
                        
.NextScrollPosX         lda BH_TabTankScrollSoftPosX; 
                        sec                         ; 
                        sbc #$08                    ; 
                        sta BH_TabTankScrollSoftPosX; 
                        
.SetVicScrollX          lda BH_TabTankScrollSoftPosX; 
                        sta BH_TabVicScrollSoftPosX ; 
                        
                        lda #BH_TabScrnTankBayScrollDoneNo ; 
                        sta BH_TabScrnTankBayScrollDone ; 
                        
TankScrollTerrainX      rts                         ; 
; -------------------------------------------------------------------------------------------------------------- ;
; TankScrollStrandHard  Does    : 
;                       Expects : 
;                       Returns : 
; -------------------------------------------------------------------------------------------------------------- ;
TankScrollStrandHard    subroutine                  ; 
                        ldx BH_TabScrnTankBayScrollPos ; 
                        jsr TankStrandAreaSetPtr    ; and work fields
                        
                        lda #BH_TabScrnTankPosYSky  ; 
                        sta BH_TabScrnTankPosY      ; 
                        
.SetNextScreenPtrs      ldx BH_TabScrnTankPosY      ; 
                        jsr TankObstIniScrnInPtr    ; 
                        
                        ldx BH_TabScrnTankPosY      ; 
                        jsr TankObstIniScrnOutPtr   ; 
                        
                        inc BLZ_ScrnRowPtrGfxOutLo  ; 
                        inc BLZ_ScrnRowPtrColoRamOutLo ; 
                        
                        ldy #BH_TabScrnTankPosXMax  ; 38 = gfx screen max width
.ScrollGfxColoRam       lda (BLZ_ScrnRowPtrGfxIn),y ; 
                        sta (BLZ_ScrnRowPtrGfxOut),y; 
                        
                        lda (BLZ_ScrnRowPtrColoRamIn),y ; 
                        sta (BLZ_ScrnRowPtrColoRamOut),y ; 
                        
                        dey                         ; 
                        bpl .ScrollGfxColoRam       ; 
                        
                        lda BH_TabScrnTankBayCharNext ; 
                        sta BH_TabScrnTankBayCharPtr; 
                        
                        lda #$00                    ; 
                        sta BH_TabScrnTankPosX      ; 
                        
                        dec BLZ_ScrnRowPtrGfxOutLo  ; 
                        dec BLZ_ScrnRowPtrColoRamOutLo ; 
                        jsr TankObstPaint           ; 
                        
                        inc BH_TabScrnTankPosY      ; 
                        
                        lda #BH_TabScrnTankPosYMax  ; gfx screen max height
                        cmp BH_TabScrnTankPosY      ; 
                        bne .SetNextScreenPtrs      ; 
                        
                        jsr TankScreenFlipFlop      ; 
                        
TankScrollStrandHardX   rts                         ; 
; -------------------------------------------------------------------------------------------------------------- ;
; TankObstIniScrnInPtr  Does    : 
;                       Expects : 
;                       Returns : 
; -------------------------------------------------------------------------------------------------------------- ;
TankObstIniScrnInPtr    subroutine                  ; 
                        lda BH_TabScrnRowPtrLo,x    ; 
                        sta BLZ_ScrnRowPtrGfxInLo   ; 
                        sta BLZ_ScrnRowPtrColoRamInLo ; 
                        
                        lda BH_TabTankActiveScreen  ; 
                        beq .ScreenB                ; screen B
                        
.ScreenA                lda BH_TabScrnRowPtrGfxAHi,x; 
                        sta BLZ_ScrnRowPtrGfxInHi   ; 
                        
                        lda BH_TabScrnRowPtrColoRamHi,x ; 
                        sta BLZ_ScrnRowPtrColoRamInHi ; 
                        
                        rts                         ; 
                        
.ScreenB                lda BH_TabScrnRowPtrGfxBHi,x; 
                        sta BLZ_ScrnRowPtrGfxInHi   ; 
                        
                        lda BH_TabScrnRowPtrColoRamHi,x ; 
                        sta BLZ_ScrnRowPtrColoRamInHi ; 
                        
TankObstIniScrnInPtrX   rts                         ; 
; -------------------------------------------------------------------------------------------------------------- ;
; TankObstIniScrnOutPtr Does    : 
;                       Expects : xr=BH_TabScrnTankPosY     
;                       Returns : 
; -------------------------------------------------------------------------------------------------------------- ;
TankObstIniScrnOutPtr   subroutine                  ; 
                        lda BH_TabScrnRowPtrLo,x    ; 
                        sta BLZ_ScrnRowPtrGfxOutLo  ; 
                        sta BLZ_ScrnRowPtrColoRamOutLo ; 
                        
                        lda BH_TabTankActiveScreen  ; 
                        beq .ScreenA                ; 
                        
.ScreenB                lda BH_TabScrnRowPtrGfxBHi,x; 
                        sta BLZ_ScrnRowPtrGfxOutHi  ; 
                        
                        lda BH_TabScrnRowPtrSaveHi,x; 
                        sta BLZ_ScrnRowPtrColoRamOutHi ; 
                        
TankObstIniScrnOutPtrX  rts                         ; 
                        
.ScreenA                lda BH_TabScrnRowPtrGfxAHi,x; 
                        sta BLZ_ScrnRowPtrGfxOutHi  ; 
                        
                        lda BH_TabScrnRowPtrSaveHi,x; 
                        sta BLZ_ScrnRowPtrColoRamOutHi ; 
                        
                        rts                         ; 
; -------------------------------------------------------------------------------------------------------------- ;
; TankScreenFlipFlop    Does    : 
;                       Expects : 
;                       Returns : 
; -------------------------------------------------------------------------------------------------------------- ;
TankScreenFlipFlop      subroutine                  ; 
                        sei                         ; 
                        
                        lda BH_TabTankActiveScreen  ; 
                        beq .SetScreenA             ; 
                        
.SetScreenB             lda BH_TabVicMemControlSetB ; 
                        sta BH_TabVicMemControl     ; 
                        
                        lda #$00                    ; 
                        bpl .SetActiveScreenFlag    ; 
                        
.SetScreenA             lda BH_TabVicMemControlSetA ; 
                        sta BH_TabVicMemControl     ; 
                        
                        lda #$01                    ; 
.SetActiveScreenFlag    sta BH_TabTankActiveScreen  ; 
                        
                        lda #BH_TabScreenTankColorYes ; 
                        sta BH_TabScreenTankColorFlag ; 
                        
                        cli                         ; 
TankScreenFlipFlopX     rts                         ; 
; -------------------------------------------------------------------------------------------------------------- ;
; TankScrollStrandSoft  Does    : 
;                       Expects : 
;                       Returns : 
; -------------------------------------------------------------------------------------------------------------- ;
TankScrollStrandSoft    subroutine                  ; 
                        ldy #$06                    ; 
                        ldx #$01                    ; 
                        lda BH_TabTankSprtScrollAddX; speed
.SetSpriteScroll        sta BH_TabSpriteScrollAddX,x; 
                        
                        inx                         ; 
                        dey                         ; 
                        bpl .SetSpriteScroll        ; 
                        
                        lda BH_TabTankScrollSoftPosX; 
                        clc                         ; 
                        adc BH_TabTankSprtScrollAddX; speed
                        sta BH_TabTankScrollSoftPosX; 
                        
TankScrollStrandSoftX   rts                         ; 
; -------------------------------------------------------------------------------------------------------------- ;
                        nop                         ; 
                        nop                         ; 
                        nop                         ; 
                        nop                         ; 
; -------------------------------------------------------------------------------------------------------------- ;
; IRQ_ScreenPartStatus  Does    : 
;                       Expects : 
;                       Returns : 
; -------------------------------------------------------------------------------------------------------------- ;
IRQ_ScreenPartStatus    subroutine                  ; 
                        lda SCROLX                  ; VIC($D016) VIC Control Register 2 (Horiz Fine Scroll)
                        and #[VIC_SoftX_Clear & VIC_MCM_Off | VIC_Cols40] ; $e8 - ###.#...
                        ora #$00                    ; 
                        tax                         ; 
                        
                        lda SCROLY                  ; VIC($D011) VIC Control Register 1 (Vert Fine Scroll)
                        and #[VIC_SoftY_Clear & VIC_RasterHi_Off] ; $78 - .####... (isolate soft scroll bits)
                        ora #$03                    ; ......##
                        tay                         ; 
                        
                        nop                         ; 
                        nop                         ; 
                        
                        lda HI_962f                 ; 
                        jsr IRQ_Wait                ; 
                        
                        stx SCROLX                  ; VIC($D016) VIC Control Register 2 (Horiz Fine Scroll)
                        sta BGCOL0                  ; VIC($D021) Background Color 0
                        
                        lda #[VIC_Video_0400 + VIC_CharS_1000 + VIC_CharS_unus] ; scrn=$0400-$07e7 chr=$1000-$17ff
                        sta VMCSB                   ; VIC($D018) VIC Chip Memory Control
                        
                        lda #$c4 + VIC_MemBank_0    ; ##...### - $03 = $0000-$3fff
                        sta CI2PRA                  ; CIA2($DD00) Data Port A - Bits 0-1 = VIC mem bank
                        
                        lda #$ff                    ; 
                        sta RASTER                  ; VIC($D012) Read : Current Raster Scan Line (Bit 8 in SCROLY = $D011)
                        
IRQ_ScreenPartStatusX   rts                         ; 
; -------------------------------------------------------------------------------------------------------------- ;
; IRQ_Wait              Does    : 
;                       Expects : 
;                       Returns : 
; -------------------------------------------------------------------------------------------------------------- ;
IRQ_Wait                subroutine                  ; 
                        pha                         ; 
                        txa                         ; 
                        
                        ldx #$21                    ; 
.Wait                   dex                         ; 
                        bne .Wait                   ; 
                        
                        tax                         ; 
                        pla                         ; 
                        
                        bit SP0X                    ; VIC($D000) Sprite 0 X-Pos (Bits 0-7 - Bit 8 in MSIGX = $D010)
                        bit D6510                   ; 6510 On-Chip I/O Data Direction
                        
IRQ_WaitX               rts                         ; 
; -------------------------------------------------------------------------------------------------------------- ;
; TankStrandAreaSetPtr  Does    : Init obstacle data area pointer and work fields
;                       Expects : xr=offset to data pointers
;                       Returns : 
; -------------------------------------------------------------------------------------------------------------- ;
TankStrandAreaSetPtr    subroutine                  ; 
                        lda BH_TabTankScrollAreaPtrHi,x; 
                        bne .SetDataPtr             ; 
                        
.ClrDataPtr             sta BLZ_TankObstDataPtrHi   ; $00
                        rts                         ; 
                        
.SetDataPtr             sta BLZ_TankObstDataPtrHi   ; 
                        
                        lda BH_TabTankScrollAreaPtrLo,x; 
                        sta BLZ_TankObstDataPtrLo   ; 
                        
                        ldy #$00                    ; 
                        lda (BLZ_TankObstDataPtr),y ; 
                        sta BH_TabTankObstPosY      ; 
                        
                        iny                         ; 
                        lda (BLZ_TankObstDataPtr),y ; 
                        sta BH_TabTankObstChrNum    ; 
                        
                        iny                         ; 
                        lda (BLZ_TankObstDataPtr),y ; 
                        sta BH_TabTankObstColor     ; 
                        sty BH_TabTankObstOffNext   ; point to next data pointers
                        
TankStrandAreaSetPtrX   rts                         ; 
; -------------------------------------------------------------------------------------------------------------- ;
; TankObstPaint         Does    : 
;                       Expects : xr=BH_TabScrnTankPosY     
;                       Returns : 
; -------------------------------------------------------------------------------------------------------------- ;
TankObstPaint           subroutine                  ; 
                        lda BLZ_TankObstDataPtrHi   ; 
                        beq .ChkSkyMax              ; 
                        
                        cpx BH_TabTankObstPosY      ; 
                        bne .ChkSkyMax              ; 
                        
                        ldy BH_TabScrnTankPosX      ; 
                        lda BH_TabTankObstChrNum    ; 
.Obstacle               sta (BLZ_ScrnRowPtrGfxOut),y; 
                        
                        lda BH_TabTankObstColor     ; 
.ObstacleColor          sta (BLZ_ScrnRowPtrColoRamOut),y ; 
                        
.ChkEndOfData           and #$80                    ; #....... - flag: end of data
                        beq .GetNextDataAreaSet     ; not set
                        
                        lda #$00                    ; done
                        sta BH_TabTankObstPosY      ; 
                        
                        rts                         ; 
                        
.GetNextDataAreaSet     ldy BH_TabTankObstOffNext   ; point to next data pointers
                        iny                         ; 
                        lda (BLZ_TankObstDataPtr),y ; 
                        sta BH_TabTankObstPosY      ; 
                        
                        iny                         ; 
                        lda (BLZ_TankObstDataPtr),y ; 
                        sta BH_TabTankObstChrNum    ; 
                        
                        iny                         ; 
                        lda (BLZ_TankObstDataPtr),y ; 
                        sta BH_TabTankObstColor     ; 
                        
                        sty BH_TabTankObstOffNext   ; point to next data pointers
                        
                        rts                         ; 
                        
.ChkSkyMax              cpx #BH_TabScrnTankPosYTreeTop ; 
                        bcs .ChkTreeTop             ; greater/equal
                        
.SetSky                 lda #$01                    ; lower is sky
                        pha                         ; 
                        lda #CYAN                   ; 
                        pha                         ; 
                        jmp .PaintObjWithColor      ; 
                        
.ChkTreeTop             bne .ChkTreeLeaf            ; greater
                        
.SetTreeTop             lda BH_TabScrnTankBayCharPtr; equal is tree top
                        clc                         ; 
                        adc #$02                    ; 
                        pha                         ; 
                        lda #[COLORAM_MCM_On | CYAN]; ....#.## - sky over tree tops
                        pha                         ; 
                        jmp .PaintObjWithColor      ; 
                        
.ChkTreeLeaf            cpx #BH_TabScrnTankPosYTreeLeaf ;
                        bne .ChkTreeTwigs           ; 
                        
.SetTreeLeaf            lda #$01                    ; BayShoreChar01
                        pha                         ; 
                        lda #GREEN                  ; 
                        pha                         ; 
                        jmp .PaintObjWithColor      ; 
                        
.ChkTreeTwigs           cpx #BH_TabScrnTankPosYTreeTwigs ;
                        bne .ChkTreeTrunk           ; 
                        
.SetTreeTwigs           lda BH_TabTankScrollAreaTabPtr ; 
                        cmp #$f7                    ; 
                        bcc .GetBayCharPtrTwig      ; 
                        
                        lda #$00                    ; strand
                        jmp .SetBayCharPtr          ; 
                        
.GetBayCharPtrTwig      lda BH_TabScrnTankBayCharPtr; 
                        clc                         ; 
                        adc #$0b                    ; 
.SetBayCharPtr          pha                         ; 
                        lda #[COLORAM_MCM_On | BLACK] ; ....#... - tree trunks
                        pha                         ; 
                        jmp .PaintObjWithColor      ; 
                        
.ChkTreeTrunk           cpx #BH_TabScrnTankPosYTreeTrunk ; 
                        bne .SetStrand              ; 
                        
.SetTreeTrunk           lda BH_TabTankScrollAreaTabPtr ; 
                        cmp #$f7                    ; 
                        bcc .GetBayCharPtrTrunk     ; lower
                        
                        lda #$00                    ; 
                        jmp .SetBayCharPtr          ; 
                        
.GetBayCharPtrTrunk     lda BH_TabScrnTankBayCharPtr; 
                        clc                         ; 
                        adc #$14                    ; 
                        jmp .SetBayCharPtr          ; 
                        
.SetStrand              lda #$00                    ; strand
                        pha                         ; 
                        lda #GREEN                  ; 
                        pha                         ; 
                        
.PaintObjWithColor      ldy BH_TabScrnTankPosX      ; 
                        pla                         ; 
                        sta (BLZ_ScrnRowPtrColoRamOut),y ; 
                        pla                         ; 
                        sta (BLZ_ScrnRowPtrGfxOut),y; 
                        
TankObstPaintX          rts                         ; 
; -------------------------------------------------------------------------------------------------------------- ;
TankScreenShowStart     subroutine                  ; 
                        lda #$00                    ; 
                        sta BH_TabScrnTankPosX      ; 
                        sta BH_TabScrnTankBayCharPtr; 
                        
.IniActualPosY          lda #BH_TabScrnTankPosYSky  ; 
                        sta BH_TabScrnTankPosY      ; 
                        
                        ldx BH_TabTankScrollAreaTabPtr ; 
                        jsr TankStrandAreaSetPtr    ; and work fields
                        
.PaintScrnPartAtPosY    ldx BH_TabScrnTankPosY      ; 
                        jsr TankObstIniScrnOutPtr   ; 
                        jsr TankObstPaint           ; 
                        
                        inc BH_TabScrnTankPosY      ; 
                        
                        lda #BH_TabScrnTankPosYMax  ; 
                        cmp BH_TabScrnTankPosY      ; 
                        bne .PaintScrnPartAtPosY    ; 
                        
                        inc BH_TabScrnTankBayCharPtr; 
                        
                        lda #$09                    ; 
                        cmp BH_TabScrnTankBayCharPtr; 
                        bne .SetNextAreaPosX        ; 
                        
                        lda #$00                    ; 
                        sta BH_TabScrnTankBayCharPtr; 
                        
.SetNextAreaPosX        inc BH_TabTankScrollAreaTabPtr ; 
                        inc BH_TabScrnTankPosX      ; 
                        
                        lda #BH_TabScrnGfxActualMaxX; 
                        cmp BH_TabScrnTankPosX      ; 
                        bne .IniActualPosY          ; 
                        
                        jsr TankScreenFlipFlop      ; 
                        
TankScreenShowStartX    rts                         ; 
; -------------------------------------------------------------------------------------------------------------- ;
; GameStart             Does    : Init all - MainLoop - Reset all - Return to BASIC
;                       Expects : 
;                       Returns : 
; -------------------------------------------------------------------------------------------------------------- ;
GameStart               jsr GameInit                ; $33c7
                        
                        ldx #$00                    ; 
.CopyKernalToRam        lda XT_ff00,x               ; 
                        sta XT_ff00,x               ; 
                        dex                         ; 
                        bne .CopyKernalToRam        ; 
                        
                        jsr C64IrqScollInit         ; 
                        
                        lda #B_Koff                 ; 
                        sta R6510                   ; 
                        jsr PlayerInit              ; 
                        
.CallMainLoop           jsr BH_ShowBayAreaMap       ; with main loop
                        
                        lda #BIKon                  ; 
                        sta R6510                   ; 
                        
                        jsr BH_C64ResetAll          ; 
                        
GameStartX              rts                         ; return to BASIC
; -------------------------------------------------------------------------------------------------------------- ;
; ResetTOD              Does    : 
;                       Expects : 
;                       Returns : 
; -------------------------------------------------------------------------------------------------------------- ;
ResetTOD                subroutine                  ; 
LO_33ea                 equ *                       ; 
                        lda #$00                    ; 
                        sta TODHRS                  ; CIA1($DC0B) Time of Day Clock Hours
                        sta TODMIN                  ; CIA1($DC0A) Time of Day Clock Minutes
                        sta TODSEC                  ; CIA1($DC09) Time of Day Clock Seconds
                        sta TODTEN                  ; CIA1($DC08) Time of Day Clock Tenths
                        
ResetTODX               rts                         ; 
; -------------------------------------------------------------------------------------------------------------- ;
; S_33f9                Does    : 
;                       Expects : 
;                       Returns : 
; -------------------------------------------------------------------------------------------------------------- ;
S_33f9                  subroutine                  ; 
                        jsr ResetTOD                ; 
                        
B_33fc                  lda TODSEC                  ; CIA1($DC09) Time of Day Clock Seconds
                        ldx TODTEN                  ; CIA1($DC08) Time of Day Clock Tenths
                        cmp HI_9617                 ; 
                        bne B_33fc                  ; 
                        
                        rts                         ; 
; -------------------------------------------------------------------------------------------------------------- ;
LO_3408                 jsr ResetTOD                ; 
B_340b                  lda TODTEN                  ; CIA1($DC08) Time of Day Clock Tenths
                        cmp HI_9618                 ; 
                        bne B_340b                  ; 
                        rts                         ; 
; -------------------------------------------------------------------------------------------------------------- ;
; S_3414                Does    : Init game screen data
;                       Expects : 
;                       Returns : 
; -------------------------------------------------------------------------------------------------------------- ;
ScreenGraphicInit       subroutine                  ; 
                        stx BLZ_ScrnRowPtrGfxInLo   ; 
                        sty BLZ_ScrnRowPtrGfxInHi   ; 
                        
                        lda #<BH_Scrn_Gfx_A         ; 
                        sta BLZ_ScrnRowPtrGfxOutLo  ; 
                        sta BLZ_ScrnRowPtrColoRamOutLo ; 
                        
                        lda #>BH_Scrn_Gfx_A         ; 
                        sta BLZ_ScrnRowPtrGfxOutHi  ; 
                        
                        lda #>COLORAM               ; 
                        sta BLZ_ScrnRowPtrColoRamOutHi ; 
                        
                        jsr ScreenGetNextDataByte   ; get next byte from BLZ_ScrnRowPtrGfxIn
                        nop                         ; 
                        nop                         ; 
                        nop                         ; 
                        jsr ScreenGetNextDataByte   ; get next byte from BLZ_ScrnRowPtrGfxIn
                        sta BH_TabBackGroundColor   ; 
                        
                        jsr ScreenGetNextDataByte   ; get next byte from BLZ_ScrnRowPtrGfxIn
                        sta BGCOL1                  ; VIC($D022) Background Color 1
                        
                        jsr ScreenGetNextDataByte   ; get next byte from BLZ_ScrnRowPtrGfxIn
                        sta BGCOL2                  ; VIC($D023) Background Color 2
                        
                        ldy #$00                    ; 
J_3440                  jsr ScreenGetNextDataByte   ; get next byte from BLZ_ScrnRowPtrGfxIn
                        
                        cmp #$ff                    ; EOD
                        beq B_3458                  ; 
                        
                        sta (BLZ_ScrnRowPtrGfxOut),y; 
                        
                        jsr ScreenGetNextDataByte   ; get next byte from BLZ_ScrnRowPtrGfxIn
                        sta (BLZ_ScrnRowPtrColoRamOut),y ; 
                        
                        iny                         ; 
                        bne B_3455                  ; 
                        
                        inc BLZ_ScrnRowPtrGfxOutHi  ; 
                        inc BLZ_ScrnRowPtrColoRamOutHi ; 
                        
B_3455                  jmp J_3440                  ; 
                        
B_3458                  jsr ScreenGetNextDataByte   ; get next byte from BLZ_ScrnRowPtrGfxIn
                        
                        cmp #$ff                    ; EOD
                        bne B_3462                  ; 
                        
                        jmp .GoScreenGraphicCharSet ; 
                        
B_3462                  sta BH_TabTankObstChrNum    ; 
                        
                        jsr ScreenGetNextDataByte   ; get next byte from BLZ_ScrnRowPtrGfxIn
                        sta BH_TabTankObstColor     ; 
                        
                        jsr ScreenGetNextDataByte   ; get next byte from BLZ_ScrnRowPtrGfxIn
                        tax                         ; 
B_346f                  lda BH_TabTankObstChrNum    ; 
                        sta (BLZ_ScrnRowPtrGfxOut),y; 
                        
                        lda BH_TabTankObstColor     ; 
                        sta (BLZ_ScrnRowPtrColoRamOut),y ; 
                        
                        iny                         ; 
                        bne B_3480                  ; 
                        
                        inc BLZ_ScrnRowPtrGfxOutHi  ; 
                        inc BLZ_ScrnRowPtrColoRamOutHi ; 
                        
B_3480                  dex                         ; 
                        bne B_346f                  ; 
                        
                        jmp J_3440                  ; 
                        
.GoScreenGraphicCharSet ldx BLZ_ScrnRowPtrGfxInLo   ; 
                        ldy BLZ_ScrnRowPtrGfxInHi   ; 
                        jsr ScreenGraphicCharSet    ; 
                        
ScreenGraphicInitX      rts                         ; 
; -------------------------------------------------------------------------------------------------------------- ;
; ScreenGetNextDataByte Does    : Get next byte
;                       Expects : 
;                       Returns : 
; -------------------------------------------------------------------------------------------------------------- ;
ScreenGetNextDataByte   subroutine                  ; 
                        ldx #$00                    ; 
                        lda (BLZ_ScrnRowPtrGfxIn,x) ; 
                        
                        inc BLZ_ScrnRowPtrGfxInLo   ; 
                        bne ScreenGetNextDataByteX  ; 
                        
                        inc BLZ_ScrnRowPtrGfxInHi   ; 
ScreenGetNextDataByteX  rts                         ; 
; -------------------------------------------------------------------------------------------------------------- ;
; ScreenGraphicCharSet  Does    : 
;                       Expects : 
;                       Returns : 
; -------------------------------------------------------------------------------------------------------------- ;
ScreenGraphicCharSet    subroutine                  ; 
                        stx BLZ_CharDataPtrInLo     ; 
                        sty BLZ_CharDataPtrInHi     ; 
                        
                        ldy #<BH_Scrn_GfxCharSets   ; $00
                        sty HI_9643                 ; 
                        sty BLZ_CharDataPtrOutLo    ; 
                        
                        ldy #>BH_Scrn_GfxCharSets   ; 
                        sty BLZ_CharDataPtrOutHi    ; 
                        
                        ldy #$01                    ; 
                        lda (BLZ_CharDataPtrIn),y   ; 
                        sta HI_9642                 ; 
                        
                        asl HI_9642                 ; 
                        rol HI_9643                 ; *2
                        asl HI_9642                 ; 
                        rol HI_9643                 ; *4
                        asl HI_9642                 ; 
                        rol HI_9643                 ; *8
                        
                        lda HI_9642                 ; 
                        clc                         ; 
                        adc BLZ_CharDataPtrOutLo    ; 
                        sta BLZ_CharDataPtrOutLo    ; 
                        
                        lda HI_9643                 ; 
                        clc                         ; 
                        adc BLZ_CharDataPtrOutHi    ; 
                        sta BLZ_CharDataPtrOutHi    ; 
                        
                        ldy #$00                    ; 
                        lda (BLZ_CharDataPtrIn),y   ; 
                        sta HI_9639                 ; 
                        
                        inc BLZ_CharDataPtrInLo     ; 
                        inc BLZ_CharDataPtrInLo     ; 
                        
                        ldx #$08                    ; 
                        ldy #$00                    ; 
.GetNextCharDataByte    lda (BLZ_CharDataPtrIn),y   ; 
                        sta (BLZ_CharDataPtrOut),y  ; 
                        dex                         ; 
                        bne .SetNextGfxByte         ; 
                        
                        ldx #$08                    ; 
                        dec HI_9639                 ; 
                        bne .SetNextGfxByte         ; 
                        
                        rts                         ; 
                        
.SetNextGfxByte         iny                         ; 
                        bne .GetNextCharDataByte    ; 
                        
                        inc BLZ_CharDataPtrInHi     ; 
                        inc BLZ_CharDataPtrOutHi    ; 
ScreenGraphicCharSetX   jmp .GetNextCharDataByte    ; 
; -------------------------------------------------------------------------------------------------------------- ;
; LO_34f9               Does    : 
;                       Expects : 
;                       Returns : 
; -------------------------------------------------------------------------------------------------------------- ;
LO_34f9                 subroutine                  ; 
                        jsr LO_350f                 ; 
                        
                        ora SPENA                   ; VIC($D015) Sprite Enable Register
                        sta SPENA                   ; VIC($D015) Sprite Enable Register
                        
                        rts                         ; 
; -------------------------------------------------------------------------------------------------------------- ;
; LO_3503               Does    : 
;                       Expects : 
;                       Returns : 
; -------------------------------------------------------------------------------------------------------------- ;
LO_3503                 subroutine                  ; 
                        jsr LO_350f                 ; 
                        
                        eor #$ff                    ; 
                        and SPENA                   ; VIC($D015) Sprite Enable Register
                        sta SPENA                   ; VIC($D015) Sprite Enable Register
                        
                        rts                         ; 
; -------------------------------------------------------------------------------------------------------------- ;
; LO_350f               Does    : 
;                       Expects : 
;                       Returns : 
; -------------------------------------------------------------------------------------------------------------- ;
LO_350f                 subroutine                  ; 
                        txa                         ; 
                        tay                         ; 
                        
                        lda #$01                    ; 
                        
J_3513                  dey                         ; 
                        bmi B_351a                  ; 
                        
                        asl a                       ; 
                        jmp J_3513                  ; 
                        
B_351a                  rts                         ; 
; -------------------------------------------------------------------------------------------------------------- ;
                        ldx #$07                    ; 
B_351d                  jsr S_352e                  ; 
                        jsr S_3570                  ; 
                        jsr S_35a3                  ; 
                        dex                         ; 
                        bne B_351d                  ; 
                        rts                         ; 
; -------------------------------------------------------------------------------------------------------------- ;
; SetYrToXrMult2        Does    : yr = xr * 2
;                       Expects : 
;                       Returns : 
; -------------------------------------------------------------------------------------------------------------- ;
SetYrToXrMult2          subroutine                  ; 
                        txa                         ; 
                        asl a                       ; 
                        tay                         ; 
                        
SetYrToXrMult2X         rts                         ; 
; -------------------------------------------------------------------------------------------------------------- ;
; S_352e                Does    : 
;                       Expects : 
;                       Returns : 
; -------------------------------------------------------------------------------------------------------------- ;
S_352e                  subroutine                  ; 
                        lda HI_9658,x               ; 
                        bne B_356f                  ; 
                        
                        lda HI_9670,x               ; 
                        cmp #$01                    ; 
                        bne B_3556                  ; 
                        
                        jsr SetYrToXrMult2          ; yr = xr * 2
                        lda SP0X,y                  ; VIC($D000) Sprite 0 X-Pos (Bits 0-7 - Bit 8 in MSIGX = $D010)
                        clc                         ; 
                        adc #$01                    ; 
                        sta SP0X,y                  ; VIC($D000) Sprite 0 X-Pos (Bits 0-7 - Bit 8 in MSIGX = $D010)
                        bcc B_3568                  ; 
                        
B_3548                  nop                         ; 
                        nop                         ; 
                        jsr LO_350f                 ; 
                        eor MSIGX                   ; VIC($D010) MSB X-Pos Sprites 0-7
                        sta MSIGX                   ; VIC($D010) MSB X-Pos Sprites 0-7
                        jmp J_356a                  ; 
B_3556                  cmp #$ff                    ; 
                        bne J_356a                  ; 
                        jsr SetYrToXrMult2          ; yr = xr * 2
                        lda SP0X,y                  ; VIC($D000) Sprite 0 X-Pos (Bits 0-7 - Bit 8 in MSIGX = $D010)
                        sec                         ; 
                        sbc #$01                    ; 
                        sta SP0X,y                  ; VIC($D000) Sprite 0 X-Pos (Bits 0-7 - Bit 8 in MSIGX = $D010)
                        bcc B_3548                  ; 
B_3568                  nop                         ; 
                        nop                         ; 
J_356a                  lda #$01                    ; 
                        sta HI_96b0,x               ; 
B_356f                  rts                         ; 
; -------------------------------------------------------------------------------------------------------------- ;
; S_3570                Does    : 
;                       Expects : 
;                       Returns : 
; -------------------------------------------------------------------------------------------------------------- ;
S_3570                  subroutine                  ; 
                        lda HI_96c0,x               ; 
                        bne B_35a2                  ; 
                        lda HI_9678,x               ; 
                        cmp #$01                    ; 
                        bne B_358b                  ; 
                        jsr SetYrToXrMult2          ; yr = xr * 2
                        lda SP0Y,y                  ; VIC($D001) Sprite 0 Y-Pos (Bits 0-7)
                        sec                         ; 
                        sbc #$01                    ; 
                        sta SP0Y,y                  ; VIC($D001) Sprite 0 Y-Pos (Bits 0-7)
                        jmp J_359b                  ; 
B_358b                  cmp #$ff                    ; 
                        bne B_359d                  ; 
                        jsr SetYrToXrMult2          ; yr = xr * 2
                        lda SP0Y,y                  ; VIC($D001) Sprite 0 Y-Pos (Bits 0-7)
                        clc                         ; 
                        adc #$01                    ; 
                        sta SP0Y,y                  ; VIC($D001) Sprite 0 Y-Pos (Bits 0-7)
J_359b                  nop                         ; 
                        nop                         ; 
B_359d                  lda #$01                    ; 
                        sta HI_96c0,x               ; 
B_35a2                  rts                         ; 
; -------------------------------------------------------------------------------------------------------------- ;
; S_35a3                Does    : 
;                       Expects : 
;                       Returns : 
; -------------------------------------------------------------------------------------------------------------- ;
S_35a3                  subroutine                  ; 
                        lda HI_96d0,x               ; 
                        bne B_35c1                  ; 
                        lda HI_9680,x               ; 
                        cmp #$01                    ; 
                        bne B_35b5                  ; 
                        inc GR_bed0,x               ; 
                        jmp J_35bc                  ; 
B_35b5                  cmp #$ff                    ; 
                        bne J_35bc                  ; 
                        dec GR_bed0,x               ; 
J_35bc                  lda #$01                    ; 
                        sta HI_96d0,x               ; 
B_35c1                  rts                         ; 
; -------------------------------------------------------------------------------------------------------------- ;
; SpriteDataCopyInit    Does    : 
;                       Expects : 
;                       Returns : 
; -------------------------------------------------------------------------------------------------------------- ;
SpriteDataCopyInit      subroutine                  ; 
                        jsr GoSetVolInit_FB         ; $fb=00
                        
                        nop                         ; 
                        
                        lda #>BH_SpriteStore        ; 
                        sta BLZ_SpriteDataPtrOutHi  ; target=$5000
                        
.ChkTyp_01_Bay          cpx #$01                    ; 
                        bne .ChkTyp_02_Cave         ; 
                        
                        ldx #$00                    ; Map: Bay Area
.GetSprtPtrMapHi        lda BH_TabSpriteDataPtrHi_Map,x; 
                        bne .SetSprtPtrMapHi        ; 
                        
                        rts                         ; 
                        
.SetSprtPtrMapHi        sta BLZ_SpriteDataPtrInHi   ; 
.GetSprtPtrMapLo        lda BH_TabSpriteDataPtrLo_Map,x; 
                        jsr SpriteDataCopy          ; 
                        
                        inx                         ; 
                        jmp .GetSprtPtrMapHi        ; 
                        
.ChkTyp_02_Cave         cpx #$02                    ; 
                        bne .ChkTyp_03_Planes       ; 
                        
                        ldx #$00                    ; Chapter: Cave Crossings
.GetSprtPtrCaveHi       lda BH_TabSpriteDataPtrHi_Cave,x ; 
                        bne .SetSprtPtrCaveHi       ; 
                        
                        rts                         ; 
                        
.SetSprtPtrCaveHi       sta BLZ_SpriteDataPtrInHi   ; 
.GetSprtPtrCaveLo       lda BH_TabSpriteDataPtrLo_Cave,x ; 
                        jsr SpriteDataCopy          ; 
                        
                        inx                         ; 
                        jmp .GetSprtPtrCaveHi       ; 
                        
.ChkTyp_03_Planes       cpx #$03                    ; 
                        bne .ChkTyp_04_Ships        ; 
                        
                        ldx #$00                    ; Chapter: Planes Shootout
.GetSprtPtrPlanesHi     lda BH_TabSpriteDataPtrHi_Plane,x ; 
                        bne .SetSprtPtrPlanesHi     ; 
                        
                        rts                         ; 
                        
.SetSprtPtrPlanesHi     sta BLZ_SpriteDataPtrInHi   ; 
.GetSprtPtrPlanesLo     lda BH_TabSpriteDataPtrLo_Plane,x ; 
                        jsr SpriteDataCopy          ; 
                        
                        inx                         ; 
                        jmp .GetSprtPtrPlanesHi     ; 
                        
.ChkTyp_04_Ships        cpx #$04                    ; 
                        bne .ChkTyp_05_Intro        ; 
                        
                        ldx #$00                    ; Chapter: Ships Shootout
.GetSprtPtrShipsHi      lda BH_TabSpriteDataPtrHi_Ship,x ; 
                        bne .SetSprtPtrShipsHi      ; 
                        
                        rts                         ; 
                        
.SetSprtPtrShipsHi      sta BLZ_SpriteDataPtrInHi   ; 
.GetSprtPtrShipsLo      lda BH_TabSpriteDataPtrLo_Ship,x ; 
                        jsr SpriteDataCopy          ; 
                        
                        inx                         ; 
                        jmp .GetSprtPtrShipsHi      ; 
                        
.ChkTyp_05_Intro        cpx #$05                    ; 
                        bne .SetTyp_06_Hill         ; 
                        
                        ldx #$00                    ; Intro Screen
.GetSprtPtrIntrosHi     lda BH_TabSpriteDataPtrHi_Tank,x ; 
                        bne .SetSprtPtrIntrosHi     ; 
                        
                        rts                         ; 
                        
.SetSprtPtrIntrosHi     sta BLZ_SpriteDataPtrInHi   ; 
.GetSprtPtrIntrosLo     lda BH_TabSpriteDataPtrLo_Tank,x ; 
                        jsr SpriteDataCopy          ; 
                        
                        inx                         ; 
                        jmp .GetSprtPtrIntrosHi     ; 
                        
.SetTyp_06_Hill         ldx #$00                    ; Chapter: Storm the Hill
.GetSprtPtrHillHi       lda BH_TabSpriteDataPtrHi_Hill,x ; 
                        bne .SetSprtPtrHillHi       ; 
                        
                        rts                         ; 
                        
.SetSprtPtrHillHi       sta BLZ_SpriteDataPtrInHi   ; 
.GetSprtPtrHillLo       lda BH_TabSpriteDataPtrLo_Hill,x ; 
                        jsr SpriteDataCopy          ; 
                        
                        inx                         ; 
SpriteDataCopyInitX     jmp .GetSprtPtrHillHi       ; 
; -------------------------------------------------------------------------------------------------------------- ;
; SpriteDataCopy        Does    : 
;                       Expects : 
;                       Returns : 
; -------------------------------------------------------------------------------------------------------------- ;
SpriteDataCopy          subroutine                  ; 
                        sta BLZ_SpriteDataPtrInLo   ; 
.SaveXr                 stx HI_9639                 ; 
                        
                        ldy #$00                    ; 
                        lda (BLZ_SpriteDataPtrIn),y ; 
                        and #$40                    ; .#......
                        beq .CpyFullSprtDataI       ; 
                        
.CpyPartSprtDataI       ldx #$40                    ; max len
                        ldy #$00                    ; 
                        lda #$00                    ; 
.ClrPartSprtArea        sta (BLZ_SpriteDataPtrOut),y; 
                        
                        iny                         ; 
                        dex                         ; 
                        bne .ClrPartSprtArea        ; 
                        
                        jsr IncSprtDataPtr          ; 
                        
.CpyPartSprtData        lda (BLZ_SpriteDataPtrIn,x) ; 
                        cmp #$ff                    ; end of data
                        beq .PtrSetNextSprtTarget   ; 
                        
                        tay                         ; 
                        jsr IncSprtDataPtr          ; 
                        
                        lda (BLZ_SpriteDataPtrIn,x) ; 
                        sta (BLZ_SpriteDataPtrOut),y; 
                        jsr IncSprtDataPtr          ; 
                        
                        jmp .CpyPartSprtData        ; 
                        
.PtrSetNextSprtTarget   lda BLZ_SpriteDataPtrOutLo  ; 
                        clc                         ; 
                        adc #$40                    ; 
                        sta BLZ_SpriteDataPtrOutLo  ; 
                        bcc .RestoreXr              ; 
                        inc BLZ_SpriteDataPtrOutHi  ; 
                        
.RestoreXr              ldx HI_9639                 ; 
.Exit                   rts                         ; 
                        
.CpyFullSprtDataI       jsr IncSprtDataPtr          ; 
                        
                        ldy #$00                    ; 
                        ldx #$3f                    ; 
.CpyFullSprtData        lda (BLZ_SpriteDataPtrIn),y ; 
                        sta (BLZ_SpriteDataPtrOut),y; 
                        iny                         ; 
                        dex                         ; 
                        bne .CpyFullSprtData        ; 
                        
                        lda BLZ_SpriteDataPtrInLo   ; 
                        clc                         ; 
                        adc #$3f                    ; 
                        sta BLZ_SpriteDataPtrInLo   ; 
                        bcc .PtrSetNextSprtTarget   ; 
                        inc BLZ_SpriteDataPtrInHi   ; 
                        
SpriteDataCopyX         jmp .PtrSetNextSprtTarget   ; 
; -------------------------------------------------------------------------------------------------------------- ;
; IncSprtDataPtr        Does    : 
;                       Expects : 
;                       Returns : 
; -------------------------------------------------------------------------------------------------------------- ;
IncSprtDataPtr          subroutine                  ; 
                        inc BLZ_SpriteDataPtrInLo   ; 
                        bne IncSprtDataPtrX         ; 
                        
                        inc BLZ_SpriteDataPtrInHi   ; 
IncSprtDataPtrX         rts                         ; 
; -------------------------------------------------------------------------------------------------------------- ;
; ScreenStatusInitColor Does    : 
;                       Expects : 
;                       Returns : 
; -------------------------------------------------------------------------------------------------------------- ;
ScreenStatusInitColor   subroutine                  ; 
                        ldx #$20                    ; 
                        ldy #$c8                    ; 
.GetNextBlank           lda #$20                    ; " "
                        sta BH_Scrn_Status + $0300,x; 
                        
                        lda #GREY                   ; 
                        sta COLORAM + $0300,x       ; ColorRAM Page $03 - $DB00($D800-$DBFF)
                        
                        inx                         ; 
                        dey                         ; 
                        bne .GetNextBlank           ; 
                        
ScreenStatusInitColorX  rts                         ; 
; -------------------------------------------------------------------------------------------------------------- ;
ScreenStatusInitGfx     lda #$75                    ; 
                        sta BH_Scrn_Status + $0320  ; 
                        sta BH_Scrn_Status + $0348  ; 
                        sta BH_Scrn_Status + $0370  ; 
                        
                        lda #$fc                    ; 
                        sta BH_Scrn_Status + $0398  ; 
                        sta BH_Scrn_Status + $03c1  ; 
                        
                        lda #$a0                    ; 
                        sta BH_Scrn_Status + $03c0  ; 
                        sta BH_Scrn_Status + $03e7  ; 
                        
                        lda #$6f                    ; 
                        sta BH_Scrn_Status + $03c2  ; 
                        sta BH_Scrn_Status + $03e5  ; 
                        
                        lda #$76                    ; 
                        sta BH_Scrn_Status + $0347  ; 
                        sta BH_Scrn_Status + $036f  ; 
                        sta BH_Scrn_Status + $0397  ; 
                        
                        lda #$fe                    ; 
                        sta BH_Scrn_Status + $03bf  ; 
                        sta BH_Scrn_Status + $03e6  ; 
                        
                        lda #$ba                    ; 
                        sta BH_Scrn_Status + $0332  ; 
                        sta BH_Scrn_Status + $0333  ; 
                        sta BH_Scrn_Status + $0334  ; 
                        sta BH_Scrn_Status + $0335  ; 
                        sta BH_Scrn_Status + $035a  ; 
                        sta BH_Scrn_Status + $035d  ; 
                        sta BH_Scrn_Status + $0382  ; 
                        sta BH_Scrn_Status + $0385  ; 
                        
                        lda #$a0                    ; 
                        sta BH_Scrn_Status + $035b  ; 
                        sta BH_Scrn_Status + $035c  ; 
                        
                        lda #$9d                    ; 
                        sta BH_Scrn_Status + $0383  ; 
                        
                        lda #$9b                    ; 
                        sta BH_Scrn_Status + $0384  ; 
                        
                        lda #LT_GREEN               ; 
                        sta COLORAM + $03ab         ; 
                        sta COLORAM + $03ac         ; 
                        
                        lda #$63                    ; 
                        sta BH_Scrn_Status + $03ab  ; 
                        sta BH_Scrn_Status + $03ac  ; 
                        
ScreenStatusInitGfxX    rts                         ; 
; -------------------------------------------------------------------------------------------------------------- ;
ScreenStatusInitShips   ldy #$02                    ; 
                        ldx #OffTextStatusLevel     ; 
                        lda #WHITE                  ; 
                        sta BH_TabScrnStatusTextColor ; 
                        jsr ScreenStatusInitLevel   ; 
                        
                        ldy #$1c                    ; 
                        ldx #OffTextStatusAmmo      ; 
                        jsr ScreenStatusTextOutRow1 ; xr=input text offset  yr=output text offset
                        
                        ldy #$04                    ; 
                        ldx #OffTextStatusShips     ; 
                        jsr ScreenStatusTextOutRow5 ; xr=input text offset  yr=output text offset
                        
                        lda #YELLOW                 ; 
                        sta BH_TabScrnStatusTextColor ; 
                        
                        ldy #$02                    ; 
                        ldx #OffTextStatusPlayer    ; 
                        jsr S_2d08                  ; 
                        
                        lda #CYAN                   ; 
                        sta BH_TabScrnStatusTextColor ; 
                        
                        ldy #$02                    ; 
                        ldx #OffTextStatusScore     ; 
                        jsr ScreenStatusTextOutRow3 ; xr=input text offset  yr=output text offset
                        
ScreenStatusInitShipsX  rts                         ; 
; -------------------------------------------------------------------------------------------------------------- ;
; S_3772                Does    : 
;                       Expects : 
;                       Returns : 
; -------------------------------------------------------------------------------------------------------------- ;
S_3772                  subroutine                  ; 
                        lda #$01                    ; 
                        dc.b $2c                    ; bit $02a9(lda) - trick to avoid a branch  
                        lda #$02                    ; 
                        dc.b $2c                    ; bit $04a9(lda) - trick to avoid a branch  
LO_3778                 lda #$04                    ; 
                        dc.b $2c                    ; bit $06a9(lda) - trick to avoid a branch  
LO_377b                 lda #$06                    ; 
                        dc.b $2c                    ; bit $08a9(lda) - trick to avoid a branch  
LO_377e                 lda #$08                    ; 
                        dc.b $2c                    ; bit $10a9(lda) - trick to avoid a branch  
LO_3781                 lda #$10                    ; 
                        dc.b $2c                    ; bit $20a9(lda) - trick to avoid a branch  
LO_3784                 lda #$20                    ; 
                        dc.b $2c                    ; bit $90a9(lda) - trick to avoid a branch
LO_3787                 lda #$90                    ; 
                        sed                         ; 
                        clc                         ; 
                        adc HI_9606                 ; 
                        sta HI_9606                 ; 
                        bcc B_379b                  ; 
                        
                        lda #$00                    ; 
                        adc HI_9607                 ; 
                        sta HI_9607                 ; 
                        
B_379b                  cld                         ; 
                        rts                         ; 
; -------------------------------------------------------------------------------------------------------------- ;
; ScreenStatusShowScore Does    : 
;                       Expects : 
;                       Returns : 
; -------------------------------------------------------------------------------------------------------------- ;
ScreenStatusShowScore   subroutine                  ; 
                        lda HI_9607                 ; 
                        jsr MakeDigit               ; xr=right nibble yr=left nibble
                        
                        cpx #$30                    ; 
                        bne B_37a9                  ; 
                        
                        ldx #$20                    ; 
B_37a9                  stx BH_Scrn_Status + $0378  ; 
                        sty BH_Scrn_Status + $0379  ; 
                        
                        lda HI_9606                 ; 
                        jsr MakeDigit               ; xr=right nibble yr=left nibble
                        
                        stx BH_Scrn_Status + $037a  ; 
                        sty BH_Scrn_Status + $037b  ; 
                        
                        lda #$30                    ; 
                        sta BH_Scrn_Status + $037c  ; 
                        sta BH_Scrn_Status + $037d  ; 
                        
                        ldy #$06                    ; 
                        ldx #$08                    ; 
                        lda #CYAN                   ; 
B_37c9                  sta COLORAM + $0370,x       ; 
                        inx                         ; 
                        dey                         ; 
                        bne B_37c9                  ; 
                        
ScreenStatusShowScoreX  rts                         ; 
; -------------------------------------------------------------------------------------------------------------- ;
; MakeDigit             Does    : 
;                       Expects : ac=digit
;                       Returns : xr=right nibble yr=left nibble
; -------------------------------------------------------------------------------------------------------------- ;
MakeDigit               subroutine                  ; 
                        pha                         ; save
                        and #$0f                    ; ....####
                        
                        clc                         ; 
                        adc #$30                    ; make digit
                        tay                         ; 
                        
                        pla                         ; restore
                        lsr a                       ; 
                        lsr a                       ; 
                        lsr a                       ; 
                        lsr a                       ; 
                        
                        clc                         ; 
                        adc #$30                    ; make digit
                        tax                         ; 
                        
MakeDigitX              rts                         ; 
; -------------------------------------------------------------------------------------------------------------- ;
LO_37e2                 lda CIAPRB                  ; CIA1($DC01) Data Port Register B
                        eor #$ff                    ; 
                        and #$20                    ; ..#..... - 
                        bne B_37ec                  ; 
                        
                        rts                         ; 
                        
B_37ec                  jsr HI_90ed                 ; 
                        
B_37ef                  lda CIAPRB                  ; CIA1($DC01) Data Port Register B
                        eor #$ff                    ; 
                        and #$20                    ; ..#..... - 
                        beq B_37ef                  ; 
                        
                        jsr HI_9102                 ; 
                        
                        rts                         ; 
; -------------------------------------------------------------------------------------------------------------- ;
LO_37fc                 lda #$30                    ; 
                        sta HI_9688                 ; 
                        
                        lda #$01                    ; 
                        sta HI_96b0                 ; 
                        
B_3806                  lda HI_96b0                 ; 
                        bne B_3806                  ; 
                        
                        rts                         ; 
; -------------------------------------------------------------------------------------------------------------- ;
MapChkIdleTimeReturn    jmp HI_66ca                 ; 
; -------------------------------------------------------------------------------------------------------------- ;
LO_380f                 eor #$ff                    ; 
                        and #$04                    ; .....#..
                        bne B_3816                  ; 
                        
                        rts                         ; 
                        
LO_3816                 subroutine                  ;                         
B_3816                  pla                         ; 
                        pla                         ; 
                        lda #$02                    ; 
                        sta HI_9608                 ; 
                        
                        rts                         ; 
; -------------------------------------------------------------------------------------------------------------- ;
LO_381e                 jmp HI_6668                 ; 
                        
LO_3821                 eor #$ff                    ; 
                        and #$04                    ; 
                        bne B_3828                  ; 
                        
                        rts                         ; 
                        
LO_3828                 subroutine                  ; 
B_3828                  pla                         ; 
                        nop                         ; 
                        nop                         ; 
                        pla                         ; 
                        
                        pla                         ; 
                        pla                         ; 
                        
                        lda #$02                    ; 
                        sta HI_9608                 ; 
                        
                        rts                         ; 
; -------------------------------------------------------------------------------------------------------------- ;
; ScreenStatusGetReady  Does    : Display 'get ready' screen
;                       Expects : 
;                       Returns : 
; -------------------------------------------------------------------------------------------------------------- ;
ScreenStatusGetReady    subroutine                  ; 
                        jsr S_217b                  ; 
                        jsr HI_8c6c                 ; 
                        
                        lda #$01                    ; screen A
                        sta BH_TabTankActiveScreen  ; 
                        jsr HI_81f7                 ; 
                        jsr ScreenStatusInitColor   ; 
                        
                        ldy #$09                    ; 
                        ldx #OffTextStatusGetReady  ; 
                        lda #WHITE                  ; 
                        sta BH_TabScrnStatusTextColor ; 
                        jsr ScreenStatusTextOutRow3 ; xr=input text offset  yr=output text offset
                        
                        lda BH_TabActualPlayerNumber; 
                        bne B_385b                  ; 
                        
                        ldx #$84                    ; 
                        jmp J_385d                  ; 
                        
B_385b                  ldx #OffTextStatusPlayerTwo ; 
J_385d                  ldy #$15                    ; 
                        jmp J_1fb2                  ; xr=input text offset  yr=output text offset
                        
J_3862                  lda #$05                    ; 
J_3864                  sta HI_9617                 ; 
                        jsr S_33f9                  ; 
                        
ScreenStatusGetReadyX   rts                         ; 
; -------------------------------------------------------------------------------------------------------------- ;
; ScreenStatusSave      Does    : Save status screen
;                       Expects : 
;                       Returns : 
; -------------------------------------------------------------------------------------------------------------- ;
ScreenStatusSave        ldx #$00                    ; 
.GetNextByte            lda BH_Scrn_Status + $0320,x; 
                        sta TabSaveStatusData,x     ; 
                        
                        lda COLORAM + $0320,x       ; 
                        sta TabSaveStatusColor,x    ; 
                        
                        inx                         ; 
                        cpx #$c8                    ; 
                        bne .GetNextByte            ; 
                        
ScreenStatusSaveX       rts                         ; 
; -------------------------------------------------------------------------------------------------------------- ;
; ScreenStatusRestore   Does    : Restore status screen
;                       Expects : 
;                       Returns : 
; -------------------------------------------------------------------------------------------------------------- ;
ScreenStatusRestore     subroutine                  ; 
                        ldx #$00                    ; 
J_3881                  lda TabSaveStatusData,x     ; 
                        sta BH_Scrn_Status + $0320,x; 
                        
                        lda TabSaveStatusColor,x    ; 
                        sta COLORAM + $0320,x       ; 
                        
                        inx                         ; 
                        jmp J_1f7f                  ; 

                        nop                         ; 
                        
ScreenStatusRestoreX    rts                         ; 
; -------------------------------------------------------------------------------------------------------------- ;
; PlayerValuesRestore   Does    : Sets game values for the actual player
;                       Expects : xr=player number
;                       Returns : 
; -------------------------------------------------------------------------------------------------------------- ;
PlayerValuesRestore     subroutine                  ; 
LO_3893                 equ *                       ; 
                        lda BH_TabPlayerLivesSav,x  ; 43
                        sta BH_TabPlayerLives       ; 44
                        
                        lda HI_9745,x               ; 45
                        sta HI_9609                 ; 46
                        
                        lda HI_9747,x               ; 47
                        sta HI_960f                 ; 48
                        
                        lda HI_974d,x               ; 4d
                        sta HI_9608                 ; 4e
                        
                        lda HI_974b,x               ; 4b
                        sta HI_9606                 ; 4c
                        
                        lda HI_975a,x               ; 4a overlap --> 49
                        sta HI_9607                 ; 4b             4a
                        
                        lda HI_9750,x               ; 50
                        sta HI_9610                 ; 51 - HillTargetsToHit
                        
                        lda BH_TabBeachSpriteLevelSav,x; 52
                        sta BH_TabBeachSpriteLevel  ; 53
                        
                        lda HI_9754,x               ; 54
                        sta HI_9619                 ; 55
                        
                        lda HI_9756,x               ; 56
                        sta HI_9742                 ; 57
                        
                        lda HI_9758,x               ; 48
                        sta HI_9612                 ; 49
                        
PlayerValuesRestoreX    rts                         ; 
; -------------------------------------------------------------------------------------------------------------- ;
; PlayerValuesSave      Does    : 
;                       Expects : 
;                       Returns : 
; -------------------------------------------------------------------------------------------------------------- ;
PlayerValuesSave        subroutine                  ; 
                        lda BH_TabPlayerLives       ; 
                        sta BH_TabPlayerLivesSav,x  ; 
                        
                        lda HI_9609                 ; 
                        sta HI_9745,x               ; 
                        
                        lda HI_960f                 ; 
                        sta HI_9747,x               ; 
                        
                        lda HI_9608                 ; 
                        sta HI_974d,x               ; 
                        
                        lda HI_9606                 ; 
                        sta HI_974b,x               ; 
                        
                        lda HI_9607                 ; 
                        sta HI_975a,x               ; 
                        
                        lda HI_9610                 ; HillTargetsToHit
                        sta HI_9750,x               ; 
                        
                        lda BH_TabBeachSpriteLevel  ; 
                        sta BH_TabBeachSpriteLevelSav,x; 
                        
                        lda HI_9619                 ; 
                        sta HI_9754,x               ; 
                        
                        lda HI_9742                 ; 
                        sta HI_9756,x               ; 
                        
                        lda HI_9612                 ; 
                        sta HI_9758,x               ; 
                        
PlayerValuesSaveX       rts                         ; 
; -------------------------------------------------------------------------------------------------------------- ;
; PlayerInit            Does    : 
;                       Expects : 
;                       Returns : 
; -------------------------------------------------------------------------------------------------------------- ;
PlayerInit              subroutine                  ; 
                        ldx #$01                    ; 
.Players                lda #$0a                    ; 
                        jsr HI_934e                 ; 
                        
                        lda #$00                    ; 
                        sta HI_974b,x               ; 
                        sta HI_975a,x               ; 
                        sta HI_9758,x               ; 
                        sta HI_9745,x               ; 
                        sta HI_9747,x               ; 
                        sta HI_9749,x               ; 
                        sta HI_974d,x               ; 
                        
                        lda #$0a                    ; 
                        sta HI_9750,x               ; 
                        lda #$01                    ; 
                        sta HI_9602,x               ; 
                        lda #$3e                    ; 
                        sta HI_9754,x               ; 
U_3947                  equ * + $01                 ; 
                        lda #$05                    ; 
                        sta BH_TabBeachSpriteLevelSav,x; 
                        lda #$a8                    ; 
                        sta HI_9756,x               ; 
                        
                        dex                         ; 
                        bpl .Players                ; 
                        
                        ldx #$00                    ; player 1
                        stx BH_TabActualPlayerNumber; 
                        
                        jsr PlayerValuesRestore     ; 
                        jsr SkillAndSidInit         ; 
                        
                        rts                         ; 
; -------------------------------------------------------------------------------------------------------------- ;
; GameInit              Does    : 
;                       Expects : 
;                       Returns : 
; -------------------------------------------------------------------------------------------------------------- ;
GameInit                subroutine                  ; 
                        ldx #$07                    ; 
B_3961                  lda #$00                    ; 
                        jsr HI_8e04                 ; sta T_9632  sta HI_9718,x rts
                        
                        sta HI_9670,x               ; 
                        sta HI_9678,x               ; 
                        sta HI_9680,x               ; 
                        sta HI_9658,x               ; 
                        sta HI_9660,x               ; 
                        sta HI_9668,x               ; 
                        sta HI_9700,x               ; 
                        sta HI_9708,x               ; 
                        sta HI_9710,x               ; 
                        sta HI_9720,x               ; 
                        sta GR_bed0,x               ; 
                        sta HI_9620,x               ; 
                        sta HI_973c                 ; 
                        
                        lda #$01                    ; 
                        sta HI_9730,x               ; 
                        sta HI_96d8,x               ; 
                        sta HI_96e8,x               ; 
                        sta HI_96f8,x               ; 
                        sta HI_9688,x               ; 
                        sta HI_9698,x               ; 
                        sta HI_96a8,x               ; 
                        sta HI_96b0,x               ; 
                        sta HI_96c0,x               ; 
                        
                        jsr HI_6653                 ; sta HI_96d0,x  sta HI_9656  rts
                        
                        dex                         ; 
                        bpl B_3961                  ; 
                        
                        lda #$20                    ; 
                        sta HI_96ff                 ; 
                        
                        rts                         ; 
; -------------------------------------------------------------------------------------------------------------- ;
; LO_39b6               Does    : 
;                       Expects : 
;                       Returns : 
; -------------------------------------------------------------------------------------------------------------- ;
LO_39b6                 subroutine                  ; 
                        jsr S_2dd9                  ; 
                        jsr ScreenStatusTextOutRow2 ; xr=input text offset  yr=output text offset (Score)
                        
                        ldy #$0a                    ; 
                        ldx #OffTextStatusGameOver  ; 
                        nop                         ; 
                        nop                         ; 
                        jsr ScreenStatusTextOutRow4 ; xr=input text offset  yr=output text offset
                        
                        lda BH_TabActualPlayerNumber; 
                        bne B_39cf                  ; 
                        
                        ldx #$84                    ; 
                        jmp J_39d1                  ; 
                        
B_39cf                  ldx #OffTextStatusPlayerTwo ; 
J_39d1                  ldy #$15                    ; 
                        jsr ScreenStatusTextOutRow4 ; xr=input text offset  yr=output text offset
                        
                        lda #$05                    ; 
                        sta HI_9617                 ; 
                        jsr HI_667d                 ; 
                        rts                         ; 
; -------------------------------------------------------------------------------------------------------------- ;
; LO_39df               Does    : 
;                       Expects : 
;                       Returns : 
; -------------------------------------------------------------------------------------------------------------- ;
LO_39df                 subroutine                  ; 
                        lda BH_TabGameMode          ; 
                        beq .ChkUserAction          ; BH_TabGameModeGame
                        
                        rts                         ; 
                        
.ChkUserAction          lda BH_TabUserAction        ; 
                        beq CheckTimer              ; BH_TabUserActionNo
; -------------------------------------------------------------------------------------------------------------- ;
; InitTOD               Does    : Init TOD
;                       Expects : 
;                       Returns : 
; -------------------------------------------------------------------------------------------------------------- ;
InitTOD                 subroutine                  ; 
                        lda #BH_TabUserActionNo     ; 
                        sta BH_TabUserAction        ; 
                        
                        lda #$00                    ; 
                        sta TO2HRS                  ; CIA2($DD0B) Time of Day Clock Hours
                        sta TO2MIN                  ; CIA2($DD0A) Time of Day Clock Minutes
                        sta TO2SEC                  ; CIA2($DD09) Time of Day Clock Seconds
                        sta TO2TEN                  ; CIA2($DD08) Time of Day Clock Tenths
                        
InitTODX                rts                         ; 
; -------------------------------------------------------------------------------------------------------------- ;
CheckTimer              subroutine                  ; 
                        lda TO2MIN                  ; CIA2($DD0A) Time of Day Clock Minutes
                        cmp #$01                    ; up to 1 minute idle time is tolerable
                        bne InitTODX                ; 
                        
.IdleTimeUp             lda #BH_TabGameModeExit     ; otherwise exit game
                        sta BH_TabGameMode          ; 
                        nop                         ; 
                        
CheckTimerX             rts                         ; 
; -------------------------------------------------------------------------------------------------------------- ;
; ScreenStatusTextOut   Does    : 
;                       Expects : xr=input text offset  yr=output text offset
;                       Returns : 
; -------------------------------------------------------------------------------------------------------------- ;
ScreenStatusTextOut     subroutine                  ; 
ScreenStatusTextOutRow1 lda #BH_Scrn_Status_OffRow1 ; 
                        dc.b $2c                    ; bit $48a9(lda) - trick to avoid a branch 
ScreenStatusTextOutRow2 lda #BH_Scrn_Status_OffRow2 ; 
                        dc.b $2c                    ; bit $70a9(lda) - trick to avoid a branch  
ScreenStatusTextOutRow3 lda #BH_Scrn_Status_OffRow3 ; 
                        dc.b $2c                    ; bit $98a9(lda) - trick to avoid a branch  
ScreenStatusTextOutRow4 lda #BH_Scrn_Status_OffRow4 ; 
                        dc.b $2c                    ; bit $c0a9(lda) - trick to avoid a branch  
ScreenStatusTextOutRow5 lda #BH_Scrn_Status_OffRow5 ; 
                        
                        sta BLZ_ScrnRowPtrStatusOutLo ; 
                        sta BLZ_ScrnRowPtrColoRamOutLo ; 
                        
                        lda #>[BH_Scrn_Status + BH_Scrn_Status_OffStart] ; 
                        sta BLZ_ScrnRowPtrStatusOutHi ; 
                        
                        lda #>[COLORAM + BH_Scrn_Status_OffStart] ; 
                        sta BLZ_ScrnRowPtrColoRamOutHi ; 
                        
                        lda BH_TabScrnStatusTextColor ; 
                        bmi .GetBlank               ; flag: $ff - blanks out
                        
J_3a2b                  lda BH_TabScreenStatusTexts,x ; 
                        beq ScreenStatusTextOutX    ; end of text
                        sta (BLZ_ScrnRowPtrStatusOut),y ; 
                        
                        lda BH_TabScrnStatusTextColor ; 
                        sta (BLZ_ScrnRowPtrColoRamOut),y ; 
                        
                        inx                         ; 
                        iny                         ; 
                        jmp J_3a2b                  ; 
                        
.GetBlank               lda #$20                    ; 
.PutBlank               sta (BLZ_ScrnRowPtrStatusOut),y ; 
                        
                        iny                         ; 
                        dex                         ; 
                        bne .PutBlank               ; 
                        
ScreenStatusTextOutX    rts                         ; 
; -------------------------------------------------------------------------------------------------------------- ;
; GetSprtSprtCollReg    Does    : 
;                       Expects : 
;                       Returns : 
; -------------------------------------------------------------------------------------------------------------- ;
GetSprtSprtCollReg      lda SPSPCL                  ; VIC($D01E) Sprite-Sprite Collision - Cleared on read
                        sta BH_TabSprtSprtCollReg   ; 
                        
GetSprtSprtCollRegX     rts                         ; 
; -------------------------------------------------------------------------------------------------------------- ;
; GetSprtBackCollReg    Does    : 
;                       Expects : 
;                       Returns : 
; -------------------------------------------------------------------------------------------------------------- ;
GetSprtBackCollReg      lda SPBGCL                  ; VIC($D01F) Sprite-Foreground Collision - Cleared on read
                        sta BH_TabSprtBackCollReg   ; 
                        
GetSprtBackCollRegX     rts                         ; 
; -------------------------------------------------------------------------------------------------------------- ;
; LO_3a53               Does    : 
;                       Expects : 
;                       Returns : 
; -------------------------------------------------------------------------------------------------------------- ;
LO_3a53                 lda HI_972a                 ; 
                        bne B_3a59                  ; 
                        
                        rts                         ; 
                        
B_3a59                  dec HI_972a                 ; 
                        
                        rts                         ; 
; -------------------------------------------------------------------------------------------------------------- ;
; LO_3a5d               Does    : 
;                       Expects : 
;                       Returns : 
; -------------------------------------------------------------------------------------------------------------- ;
LO_3a5d                 subroutine                  ; 
                        lda HI_96d7                 ; 
                        beq B_3a63                  ; 
                        
                        rts                         ; 
                        
B_3a63                  inc HI_96d7                 ; 
                        
                        lda HI_972a                 ; 
U_3a6a                  equ * + $01                 ; 
                        cmp #$0a                    ; 
                        bcs B_3a70                  ; 
                        
                        inc HI_972a                 ; 
                        
B_3a70                  rts                         ; 
; -------------------------------------------------------------------------------------------------------------- ;
LO_3a71                 lda #$0d                    ; 
A_3a73                  dc.b $2c                    ; bit $08a9(lda) - trick to avoid a branch  
                        
ScreenStatusAmmoDec     subroutine                  ; 
S_3a74                  lda #ORANGE                 ; 
                        sta BH_TabScrnStatusTextColor ; 
                        
                        jmp HI_8df0                 ; 
; -------------------------------------------------------------------------------------------------------------- ;
                        ldx #$00                    ; 
                        
LO_3a7e                 subroutine                  ; 
B_3a7e                  lda #$7c                    ; 
                        sta BH_Scrn_Status + $0365,x; 
                        
                        lda BH_TabScrnStatusTextColor ; 
                        sta COLORAM + $0365,x       ; 
                        
                        inx                         ; 
                        dey                         ; 
                        bpl B_3a7e                  ; 

LO_3a8d                 subroutine                  ; 
J_3a8d                  cpx #$0a                    ; 
                        bcs B_3a9a                  ; 
                        
                        lda #$20                    ; 
                        sta BH_Scrn_Status + $0365,x; 
                        inx                         ; 
LO_3a98                 equ * + $01                 ; gives: sta $603a                          
                        jmp J_3a8d                  ; 
                        
B_3a9a                  rts                         ; 
; -------------------------------------------------------------------------------------------------------------- ;
BL_ClearDirInJoyAction  subroutine                  ; 
                        eor #$ff                    ; flip selected bits
                        and BH_TabJoysticAction     ; clear
                        sta BH_TabJoysticAction     ; 
                        
BL_ClearDirInJoyActionX rts                         ; 
; -------------------------------------------------------------------------------------------------------------- ;
; ScreenStatusShowShips Does    : 
;                       Expects : 
;                       Returns : 
; -------------------------------------------------------------------------------------------------------------- ;
ScreenStatusShowShips   subroutine                  ; 
                        ldx #$0a                    ; 
                        ldy BH_TabPlayerLives       ; 
                        beq B_3aba                  ; 
                        
B_3aab                  lda #$51                    ; 
                        jmp HI_954b                 ; 
                        
LO_3ab0                 lda #LT_BLUE                ; 
LO_3ab2                 sta COLORAM + $03c0,x       ; 
                        inx                         ; 
                        nop                         ; 
                        dey                         ; 
                        bne B_3aab                  ; 
                        
B_3aba                  cpx #$14                    ; 
                        bne B_3abf                  ; 
                        
                        rts                         ; 
                        
B_3abf                  lda #$20                    ; 
                        sta BH_Scrn_Status + $03c0,x; 
                        
                        inx                         ; 
ScreenStatusShowShipsX  jmp B_3aba                  ; 
; -------------------------------------------------------------------------------------------------------------- ;
A_3ac8                  dc.b $00 ; .hbu.
                        dc.b $7f ; 
                        dc.b $00 ; 
                        dc.b $f7 ; 
                        dc.b $01 ; 
                        dc.b $7f ; 
                        dc.b $00 ; 
                        dc.b $73 ; 
A_3ad0                  dc.b $00 ; 
                        dc.b $7f ; 
                        dc.b $00 ; 
                        dc.b $7f ; 
                        dc.b $00 ; 
                        dc.b $7f ; 
                        dc.b $00 ; 
                        dc.b $7f ; 
                        dc.b $00 ; 
                        dc.b $7f ; 
                        dc.b $00 ; 
                        dc.b $7f ; 
                        dc.b $00 ; 
                        dc.b $7f ; 
                        dc.b $00 ; 
                        dc.b $7f ; 
A_3ae0                  dc.b $81 ; 
                        dc.b $7f ; 
                        dc.b $00 ; 
                        dc.b $7f ; 
                        dc.b $00 ; 
                        dc.b $7f ; 
                        dc.b $00 ; 
                        dc.b $7f ; 
                        dc.b $00 ; 
                        dc.b $7f ; 
                        dc.b $00 ; 
                        dc.b $77 ; 
                        dc.b $00 ; 
                        dc.b $7f ; 
                        dc.b $00 ; 
                        dc.b $09 ; 
A_3af0                  dc.b $00 ; 
                        dc.b $7f ; 
                        dc.b $00 ; 
                        dc.b $7f ; 
                        dc.b $01 ; 
                        dc.b $7b ; 
                        dc.b $00 ; 
                        dc.b $7b ; 
                        dc.b $80 ; 
                        dc.b $7f ; 
                        dc.b $7f ; 
                        dc.b $77 ; 
                        dc.b $01 ; 
                        dc.b $71 ; 
                        dc.b $84 ; 
                        dc.b $08 ; 
A_3b00                  dc.b $01 ; 
                        dc.b $09 ; 
                        dc.b $10 ; 
                        dc.b $39 ; 
                        dc.b $00 ; 
                        dc.b $7f ; 
                        dc.b $80 ; 
                        dc.b $09 ; 
                        dc.b $00 ; 
                        dc.b $7f ; 
                        dc.b $00 ; 
                        dc.b $7f ; 
                        dc.b $01 ; 
                        dc.b $3f ; 
                        dc.b $00 ; 
                        dc.b $7f ; 
A_3b10                  dc.b $00 ; 
                        dc.b $7f ; 
                        dc.b $00 ; 
                        dc.b $7f ; 
                        dc.b $00 ; 
                        dc.b $7f ; 
                        dc.b $00 ; 
                        dc.b $7f ; 
                        dc.b $00 ; 
                        dc.b $7f ; 
                        dc.b $00 ; 
                        dc.b $7f ; 
                        dc.b $00 ; 
                        dc.b $7f ; 
                        dc.b $01 ; 
                        dc.b $09 ; 
T_3b20                  dc.b $01 ; 
                        dc.b $fd ; 
                        dc.b $00 ; 
                        dc.b $7f ; 
                        dc.b $00 ; 
                        dc.b $7f ; 
                        dc.b $00 ; 
                        dc.b $7f ; 
                        dc.b $00 ; 
                        dc.b $7f ; 
                        dc.b $00 ; 
                        dc.b $7f ; 
                        dc.b $00 ; 
                        dc.b $7f ; 
                        dc.b $00 ; 
                        dc.b $ff ; 
A_3b30                  dc.b $00 ; 
                        dc.b $7f ; 
                        dc.b $00 ; 
                        dc.b $7f ; 
                        dc.b $00 ; 
                        dc.b $7f ; 
                        dc.b $00 ; 
                        dc.b $7f ; 
                        dc.b $00 ; 
                        dc.b $7f ; 
                        dc.b $00 ; 
                        dc.b $7f ; 
                        dc.b $00 ; 
                        dc.b $7f ; 
                        dc.b $01 ; 
                        dc.b $7f ; 
A_3b40                  dc.b $80 ; 
                        dc.b $ff ; 
                        dc.b $80 ; 
                        dc.b $ff ; 
                        dc.b $80 ; 
                        dc.b $ff ; 
                        dc.b $80 ; 
                        dc.b $7f ; 
                        dc.b $80 ; 
                        dc.b $ff ; 
                        dc.b $80 ; 
                        dc.b $7f ; 
                        dc.b $80 ; 
                        dc.b $ff ; 
                        dc.b $81 ; 
                        dc.b $ff ; 
A_3b50                  dc.b $80 ; 
                        dc.b $ff ; 
                        dc.b $80 ; 
                        dc.b $ff ; 
                        dc.b $80 ; 
                        dc.b $ff ; 
                        dc.b $80 ; 
                        dc.b $ff ; 
                        dc.b $80 ; 
                        dc.b $ff ; 
                        dc.b $80 ; 
                        dc.b $ff ; 
                        dc.b $80 ; 
                        dc.b $ff ; 
                        dc.b $80 ; 
                        dc.b $ff ; 
A_3b60                  dc.b $00 ; 
                        dc.b $ff ; 
                        dc.b $80 ; 
                        dc.b $ff ; 
                        dc.b $80 ; 
                        dc.b $ff ; 
                        dc.b $80 ; 
                        dc.b $89 ; 
                        dc.b $80 ; 
                        dc.b $ff ; 
                        dc.b $80 ; 
                        dc.b $f3 ; 
                        dc.b $81 ; 
                        dc.b $ff ; 
                        dc.b $80 ; 
                        dc.b $f7 ; 
A_3b70                  dc.b $80 ; 
                        dc.b $ff ; 
                        dc.b $80 ; 
                        dc.b $ff ; 
                        dc.b $80 ; 
                        dc.b $ff ; 
                        dc.b $80 ; 
                        dc.b $ff ; 
                        dc.b $00 ; 
                        dc.b $ff ; 
                        dc.b $80 ; 
                        dc.b $ff ; 
                        dc.b $80 ; 
                        dc.b $ff ; 
                        dc.b $00 ; 
                        dc.b $71 ; 
A_3b80                  dc.b $80 ; 
                        dc.b $ff ; 
                        dc.b $80 ; 
                        dc.b $ff ; 
                        dc.b $80 ; 
                        dc.b $ff ; 
                        dc.b $00 ; 
                        dc.b $ff ; 
                        dc.b $80 ; 
                        dc.b $f7 ; 
                        dc.b $80 ; 
                        dc.b $ff ; 
                        dc.b $81 ; 
                        dc.b $fb ; 
                        dc.b $d1 ; 
                        dc.b $ff ; 
A_3b90                  dc.b $80 ; 
                        dc.b $ff ; 
                        dc.b $80 ; 
                        dc.b $ff ; 
                        dc.b $80 ; 
                        dc.b $ff ; 
                        dc.b $80 ; 
                        dc.b $ff ; 
                        dc.b $80 ; 
                        dc.b $ff ; 
                        dc.b $80 ; 
                        dc.b $ff ; 
                        dc.b $80 ; 
                        dc.b $ff ; 
                        dc.b $80 ; 
                        dc.b $f7 ; 
A_3ba0                  dc.b $80 ; 
                        dc.b $7f ; 
                        dc.b $80 ; 
                        dc.b $ff ; 
                        dc.b $80 ; 
                        dc.b $ff ; 
                        dc.b $80 ; 
                        dc.b $ff ; 
                        dc.b $80 ; 
                        dc.b $ff ; 
                        dc.b $80 ; 
                        dc.b $ff ; 
                        dc.b $80 ; 
                        dc.b $ff ; 
                        dc.b $80 ; 
                        dc.b $7f ; 
A_3bb0                  dc.b $80 ; 
                        dc.b $ff ; 
                        dc.b $80 ; 
                        dc.b $ff ; 
                        dc.b $80 ; 
                        dc.b $ff ; 
                        dc.b $80 ; 
                        dc.b $ff ; 
                        dc.b $80 ; 
                        dc.b $ff ; 
                        dc.b $80 ; 
                        dc.b $ff ; 
                        dc.b $80 ; 
                        dc.b $ff ; 
                        dc.b $81 ; 
                        dc.b $ff ; 
A_3bc0                  dc.b $00 ; 
                        dc.b $7f ; 
                        dc.b $00 ; 
                        dc.b $29 ; 
                        dc.b $01 ; 
                        dc.b $7f ; 
                        dc.b $00 ; 
                        dc.b $ff ; 
                        dc.b $00 ; 
                        dc.b $7f ; 
                        dc.b $00 ; 
                        dc.b $f7 ; 
                        dc.b $01 ; 
                        dc.b $7f ; 
                        dc.b $00 ; 
                        dc.b $73 ; 
A_3bd0                  dc.b $00 ; 
                        dc.b $7f ; 
                        dc.b $00 ; 
                        dc.b $7f ; 
                        dc.b $00 ; 
                        dc.b $7f ; 
                        dc.b $00 ; 
                        dc.b $7f ; 
                        dc.b $00 ; 
                        dc.b $7f ; 
                        dc.b $00 ; 
                        dc.b $7f ; 
                        dc.b $00 ; 
                        dc.b $7f ; 
                        dc.b $00 ; 
                        dc.b $7f ; 
A_3be0                  dc.b $81 ; 
                        dc.b $7f ; 
                        dc.b $00 ; 
                        dc.b $7f ; 
                        dc.b $00 ; 
                        dc.b $7f ; 
                        dc.b $00 ; 
                        dc.b $7f ; 
                        dc.b $00 ; 
                        dc.b $7f ; 
                        dc.b $00 ; 
                        dc.b $77 ; 
                        dc.b $00 ; 
                        dc.b $7f ; 
                        dc.b $00 ; 
                        dc.b $09 ; 
A_3bf0                  dc.b $00 ; 
                        dc.b $7f ; 
                        dc.b $00 ; 
                        dc.b $7f ; 
                        dc.b $01 ; 
                        dc.b $7b ; 
                        dc.b $00 ; 
                        dc.b $7b ; 
                        dc.b $80 ; 
                        dc.b $7f ; 
                        dc.b $7f ; 
                        dc.b $77 ; 
                        dc.b $01 ; 
                        dc.b $71 ; 
                        dc.b $84 ; 
                        dc.b $08 ; 
; -------------------------------------------------------------------------------------------------------------- ;
Tab_Scrn_Gfx_Sav        equ  *
TabSaveStatusData       dc.b $03 ; 
                        dc.b $d3 ; 
                        dc.b $d3 ; 
                        dc.b $d3 ; 
                        dc.b $d3 ; 
                        dc.b $d3 ; 
                        dc.b $d3 ; 
                        dc.b $d3 ; 
                        dc.b $43 ; 
                        dc.b $d3 ; 
                        dc.b $d3 ; 
                        dc.b $d3 ; 
                        dc.b $d3 ; 
                        dc.b $d3 ; 
                        dc.b $d3 ; 
                        dc.b $d3 ; 
A_3c10                  dc.b $d3 ; 
                        dc.b $13 ; 
                        dc.b $d3 ; 
                        dc.b $d3 ; 
                        dc.b $43 ; 
                        dc.b $d3 ; 
                        dc.b $43 ; 
                        dc.b $d3 ; 
                        dc.b $d3 ; 
                        dc.b $d3 ; 
                        dc.b $d3 ; 
                        dc.b $d3 ; 
                        dc.b $d3 ; 
                        dc.b $d3 ; 
                        dc.b $d3 ; 
                        dc.b $d3 ; 
A_3c20                  dc.b $d3 ; 
                        dc.b $d3 ; 
                        dc.b $43 ; 
                        dc.b $d3 ; 
                        dc.b $b3 ; 
                        dc.b $d3 ; 
                        dc.b $d3 ; 
                        dc.b $d3 ; 
                        dc.b $03 ; 
                        dc.b $d3 ; 
                        dc.b $43 ; 
                        dc.b $d3 ; 
                        dc.b $d3 ; 
                        dc.b $d3 ; 
                        dc.b $d3 ; 
                        dc.b $d3 ; 
A_3c30                  dc.b $d3 ; 
                        dc.b $d3 ; 
                        dc.b $d3 ; 
                        dc.b $d3 ; 
                        dc.b $43 ; 
                        dc.b $d3 ; 
                        dc.b $43 ; 
                        dc.b $d3 ; 
                        dc.b $d3 ; 
                        dc.b $d3 ; 
                        dc.b $d3 ; 
                        dc.b $d3 ; 
                        dc.b $d3 ; 
                        dc.b $83 ; 
                        dc.b $d3 ; 
                        dc.b $d3 ; 
A_3c40                  dc.b $43 ; 
                        dc.b $d3 ; 
                        dc.b $43 ; 
                        dc.b $d3 ; 
                        dc.b $23 ; 
                        dc.b $d3 ; 
                        dc.b $d3 ; 
                        dc.b $d3 ; 
                        dc.b $d3 ; 
                        dc.b $d3 ; 
                        dc.b $d3 ; 
                        dc.b $d3 ; 
                        dc.b $d3 ; 
                        dc.b $d3 ; 
                        dc.b $43 ; 
                        dc.b $d3 ; 
A_3c50                  dc.b $03 ; 
                        dc.b $f3 ; 
                        dc.b $a3 ; 
                        dc.b $f3 ; 
                        dc.b $f3 ; 
                        dc.b $43 ; 
                        dc.b $f3 ; 
                        dc.b $f3 ; 
                        dc.b $d3 ; 
                        dc.b $f3 ; 
                        dc.b $d3 ; 
                        dc.b $f3 ; 
                        dc.b $f3 ; 
                        dc.b $d3 ; 
                        dc.b $f3 ; 
                        dc.b $40 ; 
A_3c60                  dc.b $f3 ; 
                        dc.b $a3 ; 
                        dc.b $f3 ; 
                        dc.b $f3 ; 
                        dc.b $d3 ; 
                        dc.b $f3 ; 
                        dc.b $d3 ; 
                        dc.b $d3 ; 
                        dc.b $d3 ; 
                        dc.b $d3 ; 
                        dc.b $d3 ; 
                        dc.b $d3 ; 
                        dc.b $d3 ; 
                        dc.b $d3 ; 
                        dc.b $43 ; 
                        dc.b $d3 ; 
A_3c70                  dc.b $43 ; 
                        dc.b $d3 ; 
                        dc.b $d3 ; 
                        dc.b $d3 ; 
                        dc.b $d3 ; 
                        dc.b $d3 ; 
                        dc.b $d3 ; 
                        dc.b $d3 ; 
                        dc.b $03 ; 
                        dc.b $f3 ; 
                        dc.b $03 ; 
                        dc.b $f3 ; 
                        dc.b $f3 ; 
                        dc.b $43 ; 
                        dc.b $f3 ; 
                        dc.b $43 ; 
A_3c80                  dc.b $f3 ; 
                        dc.b $93 ; 
                        dc.b $f3 ; 
                        dc.b $f3 ; 
                        dc.b $d3 ; 
                        dc.b $f3 ; 
                        dc.b $d3 ; 
                        dc.b $f3 ; 
                        dc.b $f3 ; 
                        dc.b $f3 ; 
                        dc.b $f3 ; 
                        dc.b $f3 ; 
                        dc.b $43 ; 
                        dc.b $f3 ; 
                        dc.b $43 ; 
                        dc.b $f3 ; 
A_3c90                  dc.b $d3 ; 
                        dc.b $f3 ; 
                        dc.b $f3 ; 
                        dc.b $d3 ; 
                        dc.b $f3 ; 
                        dc.b $d3 ; 
                        dc.b $f3 ; 
                        dc.b $f3 ; 
                        dc.b $f3 ; 
                        dc.b $f3 ; 
                        dc.b $43 ; 
                        dc.b $43 ; 
                        dc.b $f3 ; 
                        dc.b $43 ; 
                        dc.b $f3 ; 
                        dc.b $13 ; 
A_3ca0                  dc.b $03 ; 
                        dc.b $f3 ; 
                        dc.b $f3 ; 
                        dc.b $f3 ; 
                        dc.b $43 ; 
                        dc.b $f3 ; 
                        dc.b $33 ; 
                        dc.b $f3 ; 
                        dc.b $f3 ; 
                        dc.b $d3 ; 
                        dc.b $f3 ; 
                        dc.b $d3 ; 
                        dc.b $d3 ; 
                        dc.b $a3 ; 
                        dc.b $d3 ; 
                        dc.b $a3 ; 
A_3cb0                  dc.b $a3 ; 
                        dc.b $a3 ; 
                        dc.b $a3 ; 
                        dc.b $43 ; 
                        dc.b $a3 ; 
                        dc.b $43 ; 
                        dc.b $a3 ; 
                        dc.b $a3 ; 
                        dc.b $d3 ; 
                        dc.b $f3 ; 
                        dc.b $d3 ; 
                        dc.b $f3 ; 
                        dc.b $43 ; 
                        dc.b $d3 ; 
                        dc.b $f3 ; 
                        dc.b $f3 ; 
A_3cc0                  dc.b $f3 ; 
                        dc.b $f3 ; 
                        dc.b $43 ; 
                        dc.b $f3 ; 
                        dc.b $33 ; 
                        dc.b $f3 ; 
                        dc.b $f3 ; 
                        dc.b $d3 ; 
                        dc.b $0b ; 
                        dc.b $0b ; 
                        dc.b $db ; 
                        dc.b $0b ; 
                        dc.b $4b ; 
                        dc.b $0b ; 
                        dc.b $db ; 
                        dc.b $4b ; 
A_3cd0                  dc.b $0b ; 
                        dc.b $db ; 
                        dc.b $0b ; 
                        dc.b $4b ; 
                        dc.b $0b ; 
                        dc.b $ab ; 
                        dc.b $0b ; 
                        dc.b $0b ; 
                        dc.b $4b ; 
                        dc.b $0b ; 
                        dc.b $4b ; 
                        dc.b $7b ; 
                        dc.b $7b ; 
                        dc.b $7b ; 
                        dc.b $7b ; 
                        dc.b $db ; 
A_3ce0                  dc.b $db ; 
                        dc.b $bb ; 
                        dc.b $db ; 
                        dc.b $bb ; 
                        dc.b $9b ; 
                        dc.b $bb ; 
                        dc.b $bb ; 
                        dc.b $4b ; 
                        dc.b $ab ; 
                        dc.b $4b ; 
                        dc.b $ab ; 
                        dc.b $ab ; 
                        dc.b $ab ; 
                        dc.b $ab ; 
                        dc.b $db ; 
                        dc.b $ab ; 
A_3cf0                  dc.b $05 ; 
                        dc.b $45 ; 
                        dc.b $05 ; 
                        dc.b $05 ; 
                        dc.b $05 ; 
                        dc.b $05 ; 
                        dc.b $05 ; 
                        dc.b $05 ; 
                        dc.b $05 ; 
                        dc.b $05 ; 
                        dc.b $05 ; 
                        dc.b $05 ; 
                        dc.b $05 ; 
                        dc.b $05 ; 
                        dc.b $05 ; 
                        dc.b $45 ; 
; -------------------------------------------------------------------------------------------------------------- ;
TabSaveStatusColor      dc.b $05 ; 
                        dc.b $d5 ; 
                        dc.b $05 ; 
                        dc.b $d5 ; 
                        dc.b $05 ; 
                        dc.b $45 ; 
                        dc.b $05 ; 
                        dc.b $d5 ; 
                        dc.b $05 ; 
                        dc.b $55 ; 
                        dc.b $05 ; 
                        dc.b $f5 ; 
                        dc.b $05 ; 
                        dc.b $05 ; 
                        dc.b $05 ; 
                        dc.b $05 ; 
A_3d10                  dc.b $05 ; 
                        dc.b $d5 ; 
                        dc.b $05 ; 
                        dc.b $85 ; 
                        dc.b $05 ; 
                        dc.b $15 ; 
                        dc.b $d5 ; 
                        dc.b $05 ; 
                        dc.b $08 ; 
                        dc.b $d8 ; 
                        dc.b $08 ; 
                        dc.b $08 ; 
                        dc.b $08 ; 
                        dc.b $08 ; 
                        dc.b $08 ; 
                        dc.b $48 ; 
A_3d20                  dc.b $08 ; 
                        dc.b $48 ; 
                        dc.b $08 ; 
                        dc.b $a8 ; 
                        dc.b $08 ; 
                        dc.b $08 ; 
                        dc.b $d8 ; 
                        dc.b $f8 ; 
                        dc.b $d8 ; 
                        dc.b $08 ; 
                        dc.b $08 ; 
                        dc.b $08 ; 
                        dc.b $08 ; 
                        dc.b $48 ; 
                        dc.b $48 ; 
                        dc.b $08 ; 
A_3d30                  dc.b $48 ; 
                        dc.b $08 ; 
                        dc.b $38 ; 
                        dc.b $08 ; 
                        dc.b $08 ; 
                        dc.b $d8 ; 
                        dc.b $f8 ; 
                        dc.b $d8 ; 
                        dc.b $08 ; 
                        dc.b $08 ; 
                        dc.b $08 ; 
                        dc.b $08 ; 
                        dc.b $48 ; 
                        dc.b $08 ; 
                        dc.b $d8 ; 
                        dc.b $d8 ; 
A_3d40                  dc.b $08 ; 
                        dc.b $08 ; 
                        dc.b $48 ; 
                        dc.b $08 ; 
                        dc.b $08 ; 
                        dc.b $d8 ; 
                        dc.b $08 ; 
                        dc.b $d8 ; 
                        dc.b $08 ; 
                        dc.b $98 ; 
                        dc.b $08 ; 
                        dc.b $78 ; 
                        dc.b $48 ; 
                        dc.b $08 ; 
                        dc.b $48 ; 
                        dc.b $08 ; 
A_3d50                  dc.b $28 ; 
                        dc.b $48 ; 
                        dc.b $d8 ; 
                        dc.b $08 ; 
                        dc.b $d8 ; 
                        dc.b $08 ; 
                        dc.b $d8 ; 
                        dc.b $08 ; 
                        dc.b $a8 ; 
                        dc.b $08 ; 
                        dc.b $08 ; 
                        dc.b $48 ; 
                        dc.b $08 ; 
                        dc.b $48 ; 
                        dc.b $08 ; 
                        dc.b $48 ; 
A_3d60                  dc.b $08 ; 
                        dc.b $08 ; 
                        dc.b $d8 ; 
                        dc.b $d8 ; 
                        dc.b $08 ; 
                        dc.b $d8 ; 
                        dc.b $08 ; 
                        dc.b $08 ; 
                        dc.b $05 ; 
                        dc.b $05 ; 
                        dc.b $05 ; 
                        dc.b $05 ; 
                        dc.b $05 ; 
                        dc.b $05 ; 
                        dc.b $25 ; 
                        dc.b $05 ; 
A_3d70                  dc.b $65 ; 
                        dc.b $a5 ; 
                        dc.b $05 ; 
                        dc.b $a5 ; 
                        dc.b $05 ; 
                        dc.b $45 ; 
                        dc.b $00 ; 
                        dc.b $30 ; 
                        dc.b $05 ; 
                        dc.b $f5 ; 
                        dc.b $05 ; 
                        dc.b $05 ; 
                        dc.b $05 ; 
                        dc.b $d5 ; 
                        dc.b $05 ; 
                        dc.b $75 ; 
A_3d80                  dc.b $a5 ; 
                        dc.b $d5 ; 
                        dc.b $05 ; 
                        dc.b $d5 ; 
                        dc.b $05 ; 
                        dc.b $05 ; 
                        dc.b $d5 ; 
                        dc.b $05 ; 
                        dc.b $05 ; 
                        dc.b $46 ; 
                        dc.b $05 ; 
                        dc.b $45 ; 
                        dc.b $05 ; 
                        dc.b $05 ; 
                        dc.b $05 ; 
                        dc.b $05 ; 
A_3d90                  dc.b $05 ; 
                        dc.b $d5 ; 
                        dc.b $d9 ; 
                        dc.b $d9 ; 
                        dc.b $d9 ; 
                        dc.b $05 ; 
                        dc.b $05 ; 
                        dc.b $25 ; 
                        dc.b $05 ; 
                        dc.b $05 ; 
                        dc.b $05 ; 
                        dc.b $05 ; 
                        dc.b $05 ; 
                        dc.b $00 ; 
                        dc.b $00 ; 
                        dc.b $00 ; 
A_3da0                  dc.b $45 ; 
                        dc.b $05 ; 
                        dc.b $35 ; 
                        dc.b $a5 ; 
                        dc.b $05 ; 
                        dc.b $35 ; 
                        dc.b $05 ; 
                        dc.b $f5 ; 
                        dc.b $05 ; 
                        dc.b $05 ; 
                        dc.b $05 ; 
                        dc.b $05 ; 
                        dc.b $05 ; 
                        dc.b $05 ; 
                        dc.b $15 ; 
                        dc.b $05 ; 
A_3db0                  dc.b $05 ; 
                        dc.b $05 ; 
                        dc.b $a5 ; 
                        dc.b $05 ; 
                        dc.b $35 ; 
                        dc.b $05 ; 
                        dc.b $05 ; 
                        dc.b $05 ; 
                        dc.b $05 ; 
                        dc.b $d5 ; 
                        dc.b $d9 ; 
                        dc.b $d9 ; 
                        dc.b $d9 ; 
                        dc.b $d5 ; 
                        dc.b $d5 ; 
                        dc.b $d5 ; 
A_3dc0                  dc.b $d5 ; 
                        dc.b $45 ; 
                        dc.b $d5 ; 
                        dc.b $f5 ; 
                        dc.b $d5 ; 
                        dc.b $d0 ; 
                        dc.b $d0 ; 
                        dc.b $d5 ; 
                        dc.b $d5 ; 
                        dc.b $d5 ; 
                        dc.b $d5 ; 
                        dc.b $d5 ; 
                        dc.b $d5 ; 
                        dc.b $45 ; 
                        dc.b $d6 ; 
                        dc.b $45 ; 
A_3dd0                  dc.b $d5 ; 
                        dc.b $d5 ; 
                        dc.b $d5 ; 
                        dc.b $d5 ; 
                        dc.b $d5 ; 
                        dc.b $d5 ; 
                        dc.b $89 ; 
                        dc.b $d9 ; 
                        dc.b $d9 ; 
                        dc.b $45 ; 
                        dc.b $d5 ; 
                        dc.b $45 ; 
                        dc.b $d5 ; 
                        dc.b $85 ; 
                        dc.b $d5 ; 
                        dc.b $d5 ; 
A_3de0                  dc.b $05 ; 
                        dc.b $d5 ; 
                        dc.b $d5 ; 
                        dc.b $d5 ; 
                        dc.b $d5 ; 
                        dc.b $d5 ; 
                        dc.b $d5 ; 
                        dc.b $45 ; 
                        dc.b $d5 ; 
                        dc.b $85 ; 
                        dc.b $d5 ; 
                        dc.b $d5 ; 
                        dc.b $d5 ; 
                        dc.b $d5 ; 
                        dc.b $d5 ; 
                        dc.b $d5 ; 
A_3df0                  dc.b $a5 ; 
                        dc.b $d5 ; 
                        dc.b $d5 ; 
                        dc.b $45 ; 
                        dc.b $d5 ; 
                        dc.b $45 ; 
                        dc.b $d5 ; 
                        dc.b $d5 ; 
                        dc.b $d5 ; 
                        dc.b $d5 ; 
                        dc.b $d5 ; 
                        dc.b $d5 ; 
                        dc.b $d5 ; 
                        dc.b $d5 ; 
                        dc.b $d9 ; 
                        dc.b $d9 ; 
; -------------------------------------------------------------------------------------------------------------- ;
A_3e00                  dc.b $d9 ; 
                        dc.b $45 ; 
                        dc.b $d5 ; 
                        dc.b $45 ; 
                        dc.b $d5 ; 
                        dc.b $d5 ; 
                        dc.b $d5 ; 
                        dc.b $d5 ; 
                        dc.b $05 ; 
                        dc.b $d5 ; 
                        dc.b $f5 ; 
                        dc.b $f5 ; 
                        dc.b $f5 ; 
                        dc.b $f5 ; 
                        dc.b $45 ; 
                        dc.b $f5 ; 
A_3e10                  dc.b $35 ; 
                        dc.b $f5 ; 
                        dc.b $f5 ; 
                        dc.b $d5 ; 
                        dc.b $f5 ; 
                        dc.b $d5 ; 
                        dc.b $f5 ; 
                        dc.b $05 ; 
                        dc.b $d5 ; 
                        dc.b $d5 ; 
                        dc.b $d5 ; 
                        dc.b $d0 ; 
                        dc.b $d0 ; 
                        dc.b $45 ; 
                        dc.b $d5 ; 
                        dc.b $a5 ; 
A_3e20                  dc.b $d5 ; 
                        dc.b $d5 ; 
                        dc.b $d5 ; 
                        dc.b $d5 ; 
                        dc.b $d5 ; 
                        dc.b $d5 ; 
                        dc.b $15 ; 
                        dc.b $d5 ; 
                        dc.b $d5 ; 
                        dc.b $45 ; 
                        dc.b $d5 ; 
                        dc.b $45 ; 
                        dc.b $d5 ; 
                        dc.b $d5 ; 
                        dc.b $d5 ; 
                        dc.b $d5 ; 
A_3e30                  dc.b $05 ; 
                        dc.b $45 ; 
                        dc.b $f5 ; 
                        dc.b $45 ; 
                        dc.b $f5 ; 
                        dc.b $f5 ; 
                        dc.b $d5 ; 
                        dc.b $f5 ; 
                        dc.b $d5 ; 
                        dc.b $f5 ; 
                        dc.b $f5 ; 
                        dc.b $d5 ; 
                        dc.b $f5 ; 
                        dc.b $f5 ; 
                        dc.b $d5 ; 
                        dc.b $f5 ; 
A_3e40                  dc.b $45 ; 
                        dc.b $f5 ; 
                        dc.b $05 ; 
                        dc.b $f0 ; 
                        dc.b $f0 ; 
                        dc.b $d0 ; 
                        dc.b $f5 ; 
                        dc.b $d5 ; 
                        dc.b $f5 ; 
                        dc.b $f5 ; 
                        dc.b $f5 ; 
                        dc.b $f5 ; 
                        dc.b $45 ; 
                        dc.b $d5 ; 
                        dc.b $f5 ; 
                        dc.b $45 ; 
A_3e50                  dc.b $f5 ; 
                        dc.b $85 ; 
                        dc.b $f5 ; 
                        dc.b $f5 ; 
                        dc.b $d5 ; 
                        dc.b $f5 ; 
                        dc.b $d5 ; 
                        dc.b $f5 ; 
                        dc.b $05 ; 
                        dc.b $d5 ; 
                        dc.b $f5 ; 
                        dc.b $d5 ; 
                        dc.b $f6 ; 
                        dc.b $f5 ; 
                        dc.b $f5 ; 
                        dc.b $a5 ; 
A_3e60                  dc.b $a5 ; 
                        dc.b $45 ; 
                        dc.b $e5 ; 
                        dc.b $45 ; 
                        dc.b $f5 ; 
                        dc.b $15 ; 
                        dc.b $f5 ; 
                        dc.b $f5 ; 
                        dc.b $d5 ; 
                        dc.b $f5 ; 
                        dc.b $d5 ; 
                        dc.b $f5 ; 
                        dc.b $f0 ; 
                        dc.b $f0 ; 
                        dc.b $f5 ; 
                        dc.b $45 ; 
A_3e70                  dc.b $45 ; 
                        dc.b $f5 ; 
                        dc.b $45 ; 
                        dc.b $f5 ; 
                        dc.b $b5 ; 
                        dc.b $f5 ; 
                        dc.b $f5 ; 
                        dc.b $d5 ; 
                        dc.b $f5 ; 
                        dc.b $d5 ; 
                        dc.b $f5 ; 
                        dc.b $f5 ; 
                        dc.b $f5 ; 
                        dc.b $f5 ; 
                        dc.b $46 ; 
                        dc.b $f5 ; 
A_3e80                  dc.b $05 ; 
                        dc.b $05 ; 
                        dc.b $45 ; 
                        dc.b $05 ; 
                        dc.b $45 ; 
                        dc.b $05 ; 
                        dc.b $15 ; 
                        dc.b $05 ; 
                        dc.b $05 ; 
                        dc.b $05 ; 
                        dc.b $05 ; 
                        dc.b $d5 ; 
                        dc.b $75 ; 
                        dc.b $d5 ; 
                        dc.b $75 ; 
                        dc.b $75 ; 
A_3e90                  dc.b $d5 ; 
                        dc.b $75 ; 
                        dc.b $45 ; 
                        dc.b $45 ; 
                        dc.b $75 ; 
                        dc.b $45 ; 
                        dc.b $a5 ; 
                        dc.b $a5 ; 
                        dc.b $a5 ; 
                        dc.b $a5 ; 
                        dc.b $d5 ; 
                        dc.b $a5 ; 
                        dc.b $d5 ; 
                        dc.b $a5 ; 
                        dc.b $a9 ; 
                        dc.b $d9 ; 
A_3ea0                  dc.b $a9 ; 
                        dc.b $45 ; 
                        dc.b $a5 ; 
                        dc.b $d5 ; 
                        dc.b $45 ; 
                        dc.b $f5 ; 
                        dc.b $f5 ; 
                        dc.b $f5 ; 
                        dc.b $05 ; 
                        dc.b $05 ; 
                        dc.b $45 ; 
                        dc.b $05 ; 
                        dc.b $45 ; 
                        dc.b $05 ; 
                        dc.b $69 ; 
                        dc.b $b8 ; 
A_3eb0                  dc.b $05 ; 
                        dc.b $05 ; 
                        dc.b $05 ; 
                        dc.b $d5 ; 
                        dc.b $c5 ; 
                        dc.b $d5 ; 
                        dc.b $05 ; 
                        dc.b $45 ; 
                        dc.b $05 ; 
                        dc.b $d5 ; 
                        dc.b $05 ; 
                        dc.b $05 ; 
                        dc.b $d5 ; 
                        dc.b $85 ; 
                        dc.b $45 ; 
                        dc.b $05 ; 
A_3ec0                  dc.b $d5 ; 
                        dc.b $05 ; 
                        dc.b $45 ; 
                        dc.b $05 ; 
                        dc.b $d5 ; 
                        dc.b $05 ; 
                        dc.b $09 ; 
                        dc.b $09 ; 
                        dc.b $09 ; 
                        dc.b $45 ; 
                        dc.b $05 ; 
                        dc.b $45 ; 
                        dc.b $05 ; 
                        dc.b $05 ; 
                        dc.b $05 ; 
                        dc.b $05 ; 
A_3ed0                  dc.b $05 ; 
                        dc.b $45 ; 
                        dc.b $05 ; 
                        dc.b $45 ; 
                        dc.b $05 ; 
                        dc.b $a5 ; 
                        dc.b $08 ; 
                        dc.b $05 ; 
                        dc.b $d5 ; 
                        dc.b $f5 ; 
                        dc.b $d5 ; 
                        dc.b $05 ; 
                        dc.b $05 ; 
                        dc.b $05 ; 
                        dc.b $05 ; 
                        dc.b $46 ; 
A_3ee0                  dc.b $45 ; 
                        dc.b $05 ; 
                        dc.b $45 ; 
                        dc.b $05 ; 
                        dc.b $35 ; 
                        dc.b $05 ; 
                        dc.b $05 ; 
                        dc.b $d5 ; 
                        dc.b $f5 ; 
                        dc.b $d5 ; 
                        dc.b $05 ; 
                        dc.b $05 ; 
                        dc.b $05 ; 
                        dc.b $05 ; 
                        dc.b $45 ; 
                        dc.b $05 ; 
A_3ef0                  dc.b $d5 ; 
                        dc.b $d9 ; 
                        dc.b $08 ; 
                        dc.b $05 ; 
                        dc.b $05 ; 
                        dc.b $05 ; 
                        dc.b $05 ; 
                        dc.b $05 ; 
                        dc.b $05 ; 
                        dc.b $05 ; 
                        dc.b $05 ; 
                        dc.b $d5 ; 
                        dc.b $05 ; 
                        dc.b $d5 ; 
                        dc.b $f5 ; 
                        dc.b $05 ; 
A_3f00                  dc.b $05 ; 
                        dc.b $05 ; 
                        dc.b $45 ; 
                        dc.b $05 ; 
                        dc.b $45 ; 
                        dc.b $45 ; 
                        dc.b $05 ; 
                        dc.b $45 ; 
                        dc.b $05 ; 
                        dc.b $45 ; 
                        dc.b $05 ; 
                        dc.b $85 ; 
                        dc.b $05 ; 
                        dc.b $05 ; 
                        dc.b $d5 ; 
                        dc.b $05 ; 
A_3f10                  dc.b $d5 ; 
                        dc.b $05 ; 
                        dc.b $d5 ; 
                        dc.b $05 ; 
                        dc.b $d5 ; 
                        dc.b $d5 ; 
                        dc.b $05 ; 
                        dc.b $d5 ; 
                        dc.b $05 ; 
                        dc.b $48 ; 
                        dc.b $05 ; 
                        dc.b $05 ; 
                        dc.b $05 ; 
                        dc.b $05 ; 
                        dc.b $45 ; 
                        dc.b $05 ; 
A_3f20                  dc.b $0a ; 
                        dc.b $8e ; 
                        dc.b $aa ; 
                        dc.b $88 ; 
                        dc.b $aa ; 
                        dc.b $ab ; 
                        dc.b $aa ; 
                        dc.b $aa ; 
                        dc.b $a7 ; 
                        dc.b $aa ; 
                        dc.b $aa ; 
                        dc.b $aa ; 
                        dc.b $aa ; 
                        dc.b $00 ; 
                        dc.b $41 ; 
                        dc.b $08 ; 
A_3f30                  dc.b $b0 ; 
                        dc.b $18 ; 
                        dc.b $3b ; 
                        dc.b $53 ; 
                        dc.b $55 ; 
                        dc.b $c2 ; 
                        dc.b $a0 ; 
                        dc.b $a4 ; 
                        dc.b $23 ; 
                        dc.b $44 ; 
                        dc.b $4f ; 
                        dc.b $20 ; 
                        dc.b $01 ; 
                        dc.b $2a ; 
                        dc.b $4c ; 
                        dc.b $cc ; 
A_3f40                  dc.b $00 ; 
                        dc.b $66 ; 
                        dc.b $3f ; 
                        dc.b $b8 ; 
                        dc.b $18 ; 
                        dc.b $3b ; 
                        dc.b $22 ; 
                        dc.b $20 ; 
                        dc.b $45 ; 
                        dc.b $ce ; 
                        dc.b $54 ; 
                        dc.b $45 ; 
                        dc.b $52 ; 
                        dc.b $20 ; 
                        dc.b $57 ; 
                        dc.b $49 ; 
A_3f50                  dc.b $44 ; 
                        dc.b $48 ; 
                        dc.b $20 ; 
                        dc.b $58 ; 
                        dc.b $b2 ; 
                        dc.b $52 ; 
                        dc.b $4f ; 
                        dc.b $57 ; 
                        dc.b $20 ; 
                        dc.b $42 ; 
                        dc.b $05 ; 
                        dc.b $49 ; 
                        dc.b $4e ; 
                        dc.b $47 ; 
                        dc.b $20 ; 
                        dc.b $46 ; 
A_3f60                  dc.b $49 ; 
                        dc.b $4c ; 
                        dc.b $4c ; 
                        dc.b $45 ; 
                        dc.b $44 ; 
                        dc.b $00 ; 
                        dc.b $8e ; 
                        dc.b $3f ; 
                        dc.b $c4 ; 
                        dc.b $18 ; 
                        dc.b $3b ; 
                        dc.b $0b ; 
                        dc.b $20 ; 
                        dc.b $20 ; 
                        dc.b $20 ; 
                        dc.b $20 ; 
A_3f70                  dc.b $20 ; 
                        dc.b $20 ; 
                        dc.b $20 ; 
                        dc.b $20 ; 
                        dc.b $43 ; 
                        dc.b $4f ; 
                        dc.b $4c ; 
                        dc.b $4d ; 
                        dc.b $4b ; 
                        dc.b $32 ; 
                        dc.b $42 ; 
                        dc.b $4b ; 
                        dc.b $43 ; 
                        dc.b $44 ; 
                        dc.b $20 ; 
                        dc.b $02 ; 
A_3f80                  dc.b $a0 ; 
                        dc.b $1e ; 
                        dc.b $a2 ; 
                        dc.b $00 ; 
                        dc.b $bd ; 
                        dc.b $00 ; 
                        dc.b $40 ; 
                        dc.b $9d ; 
                        dc.b $00 ; 
                        dc.b $e0 ; 
                        dc.b $e8 ; 
                        dc.b $d0 ; 
                        dc.b $f7 ; 
                        dc.b $ee ; 
                        dc.b $86 ; 
                        dc.b $3f ; 
A_3f90                  dc.b $ee ; 
                        dc.b $89 ; 
                        dc.b $3f ; 
                        dc.b $88 ; 
                        dc.b $d0 ; 
                        dc.b $ee ; 
                        dc.b $a9 ; 
                        dc.b $40 ; 
                        dc.b $8d ; 
                        dc.b $86 ; 
                        dc.b $3f ; 
                        dc.b $a9 ; 
                        dc.b $e0 ; 
                        dc.b $8d ; 
                        dc.b $89 ; 
                        dc.b $3f ; 
A_3fa0                  dc.b $60 ; 
                        dc.b $99 ; 
                        dc.b $09 ; 
                        dc.b $b9 ; 
                        dc.b $3f ; 
                        dc.b $a7 ; 
                        dc.b $1f ; 
                        dc.b $99 ; 
                        dc.b $23 ; 
                        dc.b $51 ; 
                        dc.b $4d ; 
                        dc.b $45 ; 
                        dc.b $11 ; 
                        dc.b $03 ; 
                        dc.b $05 ; 
                        dc.b $21 ; 
A_3fb0                  dc.b $78 ; 
                        dc.b $a9 ; 
                        dc.b $35 ; 
                        dc.b $85 ; 
                        dc.b $01 ; 
                        dc.b $a2 ; 
                        dc.b $00 ; 
                        dc.b $a0 ; 
                        dc.b $1e ; 
                        dc.b $bd ; 
                        dc.b $00 ; 
                        dc.b $e0 ; 
                        dc.b $9d ; 
                        dc.b $00 ; 
                        dc.b $40 ; 
                        dc.b $e8 ; 
A_3fc0                  dc.b $d0 ; 
                        dc.b $f7 ; 
                        dc.b $ee ; 
                        dc.b $bb ; 
                        dc.b $3f ; 
                        dc.b $ee ; 
                        dc.b $be ; 
                        dc.b $3f ; 
                        dc.b $88 ; 
                        dc.b $d0 ; 
                        dc.b $ee ; 
                        dc.b $a9 ; 
                        dc.b $e0 ; 
                        dc.b $8d ; 
                        dc.b $bb ; 
                        dc.b $3f ; 
A_3fd0                  dc.b $a9 ; 
                        dc.b $40 ; 
                        dc.b $8d ; 
                        dc.b $be ; 
                        dc.b $3f ; 
                        dc.b $a9 ; 
                        dc.b $37 ; 
                        dc.b $85 ; 
                        dc.b $01 ; 
                        dc.b $4c ; 
                        dc.b $96 ; 
                        dc.b $3f ; 
                        dc.b $02 ; 
                        dc.b $29 ; 
                        dc.b $30 ; 
                        dc.b $00 ; 
A_3fe0                  dc.b $b4 ; 
                        dc.b $3f ; 
                        dc.b $04 ; 
                        dc.b $1d ; 
                        dc.b $8b ; 
                        dc.b $21 ; 
                        dc.b $4d ; 
                        dc.b $25 ; 
                        dc.b $92 ; 
                        dc.b $02 ; 
                        dc.b $12 ; 
                        dc.b $00 ; 
                        dc.b $00 ; 
                        dc.b $87 ; 
                        dc.b $02 ; 
                        dc.b $18 ; 
A_3ff0                  dc.b $1b ; 
                        dc.b $16 ; 
                        dc.b $12 ; 
                        dc.b $00 ; 
                        dc.b $08 ; 
                        dc.b $48 ; 
                        dc.b $0e ; 
                        dc.b $09 ; 
                        dc.b $8b ; 
                        dc.b $08 ; 
                        dc.b $4f ; 
                        dc.b $0c ; 
                        dc.b $9f ; 
                        dc.b $0b ; 
                        dc.b $1f ; 
                        dc.b $09 ; 
A_4000                  dc.b $01 ; 
                        dc.b $53 ; 
                        dc.b $22 ; 
                        dc.b $00 ; 
; -------------------------------------------------------------------------------------------------------------- ;
